/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rswriter;

import java.io.InputStream;
import java.util.Date;
import org.apache.log4j.Logger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementGC;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementType;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSConstants;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSFileHelper;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.RSPoolObject;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSFullWriter;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSWriterCreationParams;

public class RSBLOBWriter
extends RSPoolObject {
    private static Logger log = Logger.getLogger(RSBLOBWriter.class);
    private Object synchAddition = null;
    private RSFullWriter writer = null;

    public static RSBLOBWriter getRSBLOBWriter(RSWriterCreationParams intParams) throws Exception {
        intParams.properties.add((PropertyElementBase)new PropertyElementGC(PropertyElementGC.unspecified));
        intParams.properties.add((PropertyElementBase)new PropertyElementType(PropertyElementType.BLOB));
        return new RSBLOBWriter(intParams, RSFullWriter.getRSFullWriter(intParams));
    }

    public static RSBLOBWriter getRSBLOBWriter() throws Exception {
        try {
            return new RSBLOBWriter(RSFullWriter.getRSFullWriter(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.BLOB)}));
        }
        catch (Exception e) {
            log.error((Object)"could not create RSBLOBWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSBLOBWriter");
        }
    }

    public static RSBLOBWriter getRSBLOBWriter(boolean dataFlow) throws Exception {
        try {
            return new RSBLOBWriter(RSFullWriter.getRSFullWriter(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.BLOB)}, dataFlow));
        }
        catch (Exception e) {
            log.error((Object)"could not create RSBLOBWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSBLOBWriter");
        }
    }

    public static RSBLOBWriter getRSBLOBWriter(PropertyElementBase[] properties) throws Exception {
        try {
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 1];
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.BLOB);
            return new RSBLOBWriter(RSFullWriter.getRSFullWriter(props));
        }
        catch (Exception e) {
            log.error((Object)"could not create RSBLOBWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSBLOBWriter");
        }
    }

    public static RSBLOBWriter getRSBLOBWriter(PropertyElementBase[] properties, boolean dataFlow) throws Exception {
        try {
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 1];
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.BLOB);
            return new RSBLOBWriter(RSFullWriter.getRSFullWriter(props, dataFlow));
        }
        catch (Exception e) {
            log.error((Object)"could not create RSSimpelWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSSimpelWriter");
        }
    }

    protected RSBLOBWriter(RSFullWriter writer) throws Exception {
        this.writer = writer;
        this.synchAddition = new Object();
    }

    protected RSBLOBWriter(RSWriterCreationParams initParams, RSFullWriter writer) throws Exception {
        this.writer = writer;
        this.synchAddition = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSLocator getRSLocator(RSResourceType type) throws Exception {
        try {
            Object object = this.synchAddition;
            synchronized (object) {
                return this.writer.getRSLocator(type);
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve RSLocator. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve RSLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSLocator getRSLocator(RSResourceType type, GCUBEScope scope) throws Exception {
        try {
            Object object = this.synchAddition;
            synchronized (object) {
                return this.writer.getRSLocator(type, scope);
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve RSLocator. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve RSLocator");
        }
    }

    public RSConstants.CONTROLFLOW more(long time) throws Exception {
        try {
            return this.writer.more(time);
        }
        catch (Exception e) {
            log.error((Object)"Could not check if more records are needed. Throwing Exception", (Throwable)e);
            throw new Exception("Could not check if more records are needed");
        }
    }

    public boolean isFlowControled() throws Exception {
        return this.writer.isFlowControled();
    }

    public boolean addResults(ResultElementBLOBBase record) throws Exception {
        log.trace((Object)"client calls addResults ");
        Object object = this.synchAddition;
        synchronized (object) {
            try {
                boolean success = true;
                this.writer.startNewPart();
                this.writer.addResults((ResultElementBase)record);
                this.writer.startNewPart();
                try {
                    this.writer.wrapFile(RSFileHelper.persistStream((InputStream)record.getContentOfBLOB()));
                }
                catch (Exception e) {
                    log.error((Object)"Could not persist document.setting incomplete", (Throwable)e);
                    success = false;
                }
                return success;
            }
            catch (Exception e) {
                log.error((Object)"Could not perform addition. Throwing Exception", (Throwable)e);
                throw new Exception("Could not perform addition");
            }
        }
    }

    public boolean addResults(ResultElementBLOBBase[] record) throws Exception {
        Object object = this.synchAddition;
        synchronized (object) {
            try {
                boolean success = true;
                for (int i = 0; i < record.length; ++i) {
                    boolean s = this.addResults(record[i]);
                    if (s || !success) continue;
                    success = false;
                }
                return success;
            }
            catch (Exception e) {
                log.error((Object)"Could not perform addition. Throwing Exception", (Throwable)e);
                throw new Exception("Could not perform addition");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        Object object = this.synchAddition;
        synchronized (object) {
            try {
                this.writer.startNewPart();
                this.writer.endAuthoring();
            }
            catch (Exception e) {
                log.error((Object)"Could not close writer. Throwing Exception", (Throwable)e);
                throw new Exception("Could not close writer");
            }
        }
    }

    public void overrideProperties(PropertyElementBase[] properties) throws Exception {
        try {
            this.writer.overrideProperties(properties);
        }
        catch (Exception e) {
            log.error((Object)"could not override properties. Throwing Exception", (Throwable)e);
            throw new Exception("could not override properties");
        }
    }

    public void overrideProperties(String properties) throws Exception {
        try {
            this.writer.overrideProperties(properties);
        }
        catch (Exception e) {
            log.error((Object)"could not override properties. Throwing Exception", (Throwable)e);
            throw new Exception("could not override properties");
        }
    }

    public void disableAccessLeasing() throws Exception {
        this.writer.disableAccessLeasing();
    }

    public void extendAccessLeasing(int extend) throws Exception {
        this.writer.extendAccessLeasing(extend);
    }

    public int getAccessLeasing() throws Exception {
        return this.writer.getAccessLeasing();
    }

    public boolean isForward() throws Exception {
        return this.writer.isForward();
    }

    public boolean setForward(boolean f) throws Exception {
        return this.writer.setForward(f);
    }

    public Date getTimeLeasing() throws Exception {
        return this.writer.getTimeLeasing();
    }

    public boolean extendTimeLeasing(Date extend) throws Exception {
        return this.writer.extendTimeLeasing(extend);
    }

    public void disableTimeLeasing() throws Exception {
        this.writer.disableTimeLeasing();
    }
}

