/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsclient.elements;

import java.net.URI;
import java.security.PrivateKey;
import org.apache.log4j.Logger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.WSRSSessionToken;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSType;

public class RSLocator {
    private static Logger log = Logger.getLogger(RSLocator.class);
    private RSResourceType rsType;
    private String locator;
    private WSRSSessionToken WStoken = null;
    private GCUBEScope scope = null;
    private PrivateKey privKey = null;

    public void setScope(GCUBEScope new_scope) {
        this.scope = new_scope;
    }

    public GCUBEScope getScope() {
        return this.scope;
    }

    public RSLocator(RSResourceType rsType, String locator) {
        this.rsType = rsType;
        this.locator = locator;
        this.WStoken = null;
        this.scope = null;
    }

    public RSLocator(RSResourceType rsType, String locator, GCUBEScope scope) {
        this.rsType = rsType;
        this.locator = locator;
        this.WStoken = null;
        this.scope = scope;
    }

    public RSLocator(String locator) throws Exception {
        this.locator = locator;
        this.rsType = RSResourceWSRFType.isOfType(locator) ? new RSResourceWSRFType() : (RSResourceWSType.isOfType(locator) ? new RSResourceWSType() : new RSResourceLocalType());
        this.WStoken = null;
        this.scope = null;
    }

    public RSLocator(String locator, GCUBEScope scope) throws Exception {
        this.locator = locator;
        this.rsType = RSResourceWSRFType.isOfType(locator) ? new RSResourceWSRFType() : (RSResourceWSType.isOfType(locator) ? new RSResourceWSType() : new RSResourceLocalType());
        this.WStoken = null;
        this.scope = scope;
    }

    public RSResourceType getRSResourceType() {
        return this.rsType;
    }

    public String getLocator() {
        return this.locator;
    }

    public URI getURI() throws Exception {
        if (this.rsType instanceof RSResourceWSRFType) {
            return RSResourceWSRFType.getURI(this.locator);
        }
        if (this.rsType instanceof RSResourceWSType) {
            return RSResourceWSType.getURI(this.locator);
        }
        log.error((Object)"Cannot get URI from RSResourceLocalType. Throwing Exception");
        throw new Exception("Cannot get URI from RSResourceLocalType");
    }

    public String getSessionToken() throws Exception {
        try {
            if (this.rsType instanceof RSResourceWSRFType || this.rsType instanceof RSResourceLocalType) {
                return "";
            }
            if (this.WStoken == null) {
                this.WStoken = WSRSSessionToken.deserialize((String)this.locator);
            }
            return this.WStoken.getSessionToken();
        }
        catch (Exception e) {
            log.error((Object)"problem parsing the locator or the locator does not support session tokens. throwing exceptions", (Throwable)e);
            throw new Exception("problem parsing the locator or the locator does not support session tokens");
        }
    }

    public PrivateKey getPrivKey() {
        return this.privKey;
    }

    public void setPrivKey(PrivateKey privKey) {
        this.privKey = privKey;
    }
}

