package org.gcube.searchsystem.searchsystemservice;

import gr.uoa.di.madgik.commons.channel.proxy.tcp.ChannelTCPConnManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionEngineConfig;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngCallbackTCPConnManagerEntry;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngTCPConnManagerEntry;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.is.InformationSystem;
import gr.uoa.di.madgik.ss.StorageSystem;

import java.util.ArrayList;
import java.util.List;


import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.searchsystem.environmentadaptor.ResourceRegistryAdapter;

public class ServiceContext extends GCUBEServiceContext {

	
	private static final int MAXATTEMPTS = 10;
	
	private EnvHintCollection hints = new EnvHintCollection();;
	
	/** Single context instance, created eagerly */
	private static ServiceContext cache = new ServiceContext();
	
	static GCUBELog logger = new GCUBELog(ServiceContext.class);
	
	/** Returns cached instance */
	public static ServiceContext getContext() {return cache;}
	
	/** Prevents accidental creation of more instances */
	private ServiceContext(){};
		
	/**
	 * {@inheritDoc}
	 */
	public String getJNDIName() {return "gcube/searchsystem/SearchSystemService";}
	
	@Override
	protected void onReady() throws Exception
	{
		super.onReady();
		
		//initialize java loggers
//		InitLogging();
		
		EnvHintCollection Hints=new EnvHintCollection();
		Hints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceClass",new EnvHint(ServiceContext.getContext().getService().getServiceClass())));
		Hints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceName",new EnvHint(ServiceContext.getContext().getService().getServiceName())));
		
		logger.info("Initalizing TCPManager");
		TCPConnectionManager.Init(new TCPConnectionManagerConfig(
				GHNContext.getContext().getHostname(), new ArrayList<PortRange>(), true));
		TCPConnectionManager.RegisterEntry(new TCPConnectionHandler());
		TCPConnectionManager.RegisterEntry(new TCPStoreConnectionHandler());	
		
		logger.info("Initalizing Execution Engine Environment");
		logger.info("Registering entries");
		TCPConnectionManager.RegisterEntry(new ExecEngTCPConnManagerEntry());
		TCPConnectionManager.RegisterEntry(new ExecEngCallbackTCPConnManagerEntry());
		TCPConnectionManager.RegisterEntry(new ChannelTCPConnManagerEntry());

		logger.info("Initializing Execution Engine");
		ExecutionEngine.Init(new ExecutionEngineConfig(ExecutionEngineConfig.InfinitePlans));
		logger.info("Collecting Environment Hints");
		logger.info("Initializing Information System Provider");
		InformationSystem.Init(this.GetInformationSystemProvider(), Hints);
		
		
		parseOperatorNodeSelectorThreshold();
		parseComplexPlanLevels();
		parseComplexPlanNumNodes();
		parseMaxCollocationCost();
		parseDatasourceNodeSelector();
		parseDatasourceNodeSelectorTieBreaker();
		parseOperatorNodeSelector();
		parseOperatorNodeSelectorTieBreaker();
		parseNodeAssignmentPolicy();
		parseExcludeLocal();
		//initialize the ResourceRegistryAdapter which will be used in the search operations
		int attempts = 0;
		while(attempts<MAXATTEMPTS) {
			if(ResourceRegistryAdapter.initializeAdapter()) {
				return;
			} else {
				Thread.sleep(1000);
				attempts++;
			}
		}
		logger.error("Could not initialize Resource Registry Adaptor");
	}
	
	private Float parseOperatorNodeSelectorThreshold()
	{
		Object ct = ServiceContext.getContext().getProperty("operatorNodeSelectorThreshold", false);
		if(ct==null) return null;
		this.hints.AddHint(new NamedEnvHint("OperatorNodeSelectorThreshold", new EnvHint(ct.toString())));
		logger.info("Using operator node selector threshold: " + ct.toString());
		return (Float)ct;
	}
	
	private Integer parseComplexPlanLevels()
	{
		Object ct = ServiceContext.getContext().getProperty("complexPlanLevels", false);
		if(ct==null) return null;
		this.hints.AddHint(new NamedEnvHint("ComplexPlanLevels", new EnvHint(ct.toString())));
		logger.info("Using complex plan levels: " + ct.toString());
		return (Integer)ct;
	}
	
	private Integer parseComplexPlanNumNodes()
	{
		Object ct = ServiceContext.getContext().getProperty("complexPlanNumNodes", false);
		if(ct==null) return null;
		this.hints.AddHint(new NamedEnvHint("ComplexPlanNumNodes", new EnvHint(ct.toString())));
		logger.info("Using complex plan num nodes: " + ct.toString());
		return (Integer)ct;
	}
	
	private Float parseMaxCollocationCost()
	{
		Object ct = ServiceContext.getContext().getProperty("maximumCollocationCost", false);
		if(ct==null) return null;
		this.hints.AddHint(new NamedEnvHint("MaxCollocationCost", new EnvHint(ct.toString())));
		logger.info("Using maximum collocation cost: " + ct.toString());
		return (Float)ct;
	}
	
	private String parseNodeAssignmentPolicy()
	{
		Object ap = ServiceContext.getContext().getProperty("nodeAssignmentPolicy", false);
		if(ap==null) return null;
		this.hints.AddHint(new NamedEnvHint("NodeAssignmentPolicy", new EnvHint(ap.toString())));
		logger.info("Using node assignment policy: " + ap.toString());
		return ap.toString();
	}
	
	private Boolean parseExcludeLocal()
	{
		Object el = ServiceContext.getContext().getProperty("excludeLocal", false);
		if(el==null) return null;
		this.hints.AddHint(new NamedEnvHint("ExcludeLocal", new EnvHint(el.toString())));
		logger.info(((Boolean)el ? "E": "Not e") + "xcluding local node");
		return (Boolean)el;
	}
	
	private String parseDatasourceNodeSelector()
	{
		Object ns = ServiceContext.getContext().getProperty("datasourceNodeSelector", false);
		if(ns==null) return null;
		this.hints.AddHint(new NamedEnvHint("DataSourceNodeSelector", new EnvHint(ns.toString())));
		logger.info("Using data source node selector: " + ns.toString());
		return (String)ns;
	}
	
	private String parseDatasourceNodeSelectorTieBreaker()
	{
		Object ns = ServiceContext.getContext().getProperty("datasourceNodeSelectorTieBreaker", false);
		if(ns==null) return null;
		this.hints.AddHint(new NamedEnvHint("DataSourceNodeSelectorTieBreaker", new EnvHint(ns.toString())));
		logger.info("Using data source node selector tie breaker: " + ns.toString());
		return (String)ns;
	}
	
	private String parseOperatorNodeSelectorTieBreaker()
	{
		Object ns = ServiceContext.getContext().getProperty("operatorNodeSelectorTieBreaker", false);
		if(ns==null) return null;
		this.hints.AddHint(new NamedEnvHint("OperatorNodeSelectorTieBreaker", new EnvHint(ns.toString())));
		logger.info("Using operator node selector tie breaker: " + ns.toString());
		return (String)ns;
	}
	
	private String parseOperatorNodeSelector()
	{
		Object ns = ServiceContext.getContext().getProperty("operatorNodeSelector", false);
		if(ns==null) return null;
		this.hints.AddHint(new NamedEnvHint("OperatorNodeSelector", new EnvHint(ns.toString())));
		logger.info("Using operator node selector: " + ns.toString());
		return (String)ns;
	}
	
	private String GetInformationSystemProvider()
	{
		Object informationProviderObj = ServiceContext.getContext().getProperty("providerInformationName", false);
		if(informationProviderObj==null) return null;
		return informationProviderObj.toString();
	}

	public EnvHintCollection getHints()
	{
		return this.hints;
	}
/*	private void InitLogging() throws SecurityException, IOException
	{
		logger.info("Initalizing Logging Environment");
		
		InputStream is = ServiceContext.class.getResourceAsStream(this.getLoggingConfigLocation());
		if(is==null) throw new IllegalStateException("Could not find logging config location "+this.getLoggingConfigLocation());
		LogManager.getLogManager().readConfiguration(is);
		is.close();
		
	}
	
	private String getLoggingConfigLocation()
	{
		Object loggingObj = ServiceContext.getContext().getProperty("loggingConfigLocation", false);
		if(loggingObj==null) return null;
		return loggingObj.toString();
	}*/

}
