/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.consumer.service.helpers;

import com.google.common.collect.BiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.gcube.datatransformation.DataTransformationClient;
import org.gcube.search.sru.consumer.common.resources.SruConsumerResource;
import org.gcube.search.sru.consumer.service.helpers.ParserHelper;
import org.gcube.search.sru.consumer.service.helpers.ResultSetHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResultSetHelpers {
    static final long RSTIMEOUT = 30L;
    static final ExecutorService executorService = Executors.newCachedThreadPool();
    static final Logger logger = LoggerFactory.getLogger(ResultSetHelpers.class);

    static List<String> getFieldsIds(List<String> fieldNames, Map<String, String> namesToIds) {
        ArrayList ids = Lists.newArrayList();
        for (String fieldName : fieldNames) {
            String id = namesToIds != null && namesToIds.containsKey(fieldName) ? namesToIds.get(fieldName) : fieldName;
            ids.add(id);
        }
        return ids;
    }

    public static String writeResponseFromUrlToGRS2(DataTransformationClient dtsClient, String urlString, SruConsumerResource resource, List<String> projections, BiMap<String, String> fieldsMapping, String snippetTranslatedField) throws Exception {
        long starttime = System.currentTimeMillis();
        ArrayList<String> projectedFields = projections != null ? new ArrayList<String>(projections) : new ArrayList(resource.getPresentables());
        List records = ParserHelper.parseResponse((DataTransformationClient)dtsClient, (String)urlString, (SruConsumerResource)resource, projections, fieldsMapping, (String)snippetTranslatedField);
        logger.info("records extracted : " + records);
        String idField = resource.getRecordIDField();
        projectedFields.remove(idField);
        if (projectedFields.contains(snippetTranslatedField)) {
            projectedFields.remove(snippetTranslatedField);
            projectedFields.add("S");
        }
        logger.info("projectedFields    : " + projectedFields);
        List projectedFieldsIds = ResultSetHelpers.getFieldsIds(projectedFields, fieldsMapping);
        logger.info("projectedFieldsIds : " + projectedFieldsIds);
        RecordWriter rsWriter = ResultSetHelpers.initRSWriterForSearchHits((String)idField, (List)projectedFieldsIds);
        rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", String.valueOf(records.size())));
        1 writerRun = new /* Unavailable Anonymous Inner Class!! */;
        executorService.execute((Runnable)writerRun);
        String locator = rsWriter.getLocator().toString();
        logger.info("results locator : " + locator);
        return locator;
    }

    public static RecordWriter<GenericRecord> initRSWriterForSearchHits(String idField, List<String> returnFields) throws Exception {
        logger.info("Initializing gRS2 writer");
        logger.info("(1/3) getting field definitions");
        FieldDefinition[] fieldDef = null;
        try {
            fieldDef = ResultSetHelpers.createFieldDefinition((String)idField, returnFields);
        }
        catch (Exception e) {
            logger.error("Could not create field definition: ", (Throwable)e);
            throw e;
        }
        logger.info("(2/3) creating record definitions");
        RecordDefinition[] definition = new RecordDefinition[]{new GenericRecordDefinition(fieldDef)};
        logger.info("(3/3) creating rsWriter");
        return new RecordWriter((IWriterProxy)new TCPWriterProxy(), definition, 200, 1, 0.5f);
    }

    static boolean writeRecordTogRS2(Map<String, String> record, List<String> projectedFields, RecordWriter<GenericRecord> rsWriter, long rsTimeout) throws GRS2WriterException {
        if (rsWriter.getStatus() != IBuffer.Status.Open) {
            logger.info("result set was not open before writing record : " + record);
            return false;
        }
        ArrayList fields = Lists.newArrayList();
        String objectIDField = record.get("ObjectID");
        if (objectIDField == null) {
            objectIDField = "noID";
        }
        logger.info("    adding field id with value : " + objectIDField);
        fields.add(new StringField(objectIDField));
        fields.add(new StringField(record.get("gDocCollectionID")));
        for (String fieldName : projectedFields) {
            String value = record.get(fieldName);
            logger.info("    adding field : " + fieldName + " with value : " + value);
            fields.add(new StringField(value));
        }
        if (rsWriter.getStatus() != IBuffer.Status.Open) {
            logger.info("result set was not open after constructing fields of record : " + record);
            return false;
        }
        GenericRecord rec = new GenericRecord();
        rec.setFields((Field[])Iterables.toArray((Iterable)fields, Field.class));
        while (!rsWriter.put((Record)rec, rsTimeout, TimeUnit.SECONDS)) {
            logger.info("record : " + record + " was not written");
            if (rsWriter.getStatus() == IBuffer.Status.Open) continue;
        }
        logger.info("record was successfully written");
        return true;
    }

    public static FieldDefinition[] createFieldDefinition(String idField, List<String> returnFields) throws Exception {
        ArrayList fieldDef = Lists.newArrayList();
        fieldDef.add(new StringFieldDefinition("ObjectID"));
        fieldDef.add(new StringFieldDefinition("gDocCollectionID"));
        logger.info("idField        : " + idField);
        logger.info("return  fields : " + returnFields);
        if (returnFields != null) {
            Iterator<String> i$ = returnFields.iterator();
            while (i$.hasNext()) {
                String fieldName;
                String fieldID = fieldName = i$.next();
                fieldDef.add(new StringFieldDefinition(fieldID));
            }
        }
        return (FieldDefinition[])Iterables.toArray((Iterable)fieldDef, FieldDefinition.class);
    }
}

