/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.consumer.service.helpers;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryParserHelper {
    public String getQueryPart(String query) {
        List queryParts = Splitter.on((String)" project ").omitEmptyStrings().splitToList((CharSequence)query);
        String queryPart = null;
        queryPart = queryParts.size() > 2 ? Joiner.on((String)" ").join(queryParts.subList(0, queryParts.size() - 2)) : (String)queryParts.get(0);
        return queryPart;
    }

    public List<String> getProjectPart(String query, List<String> presentablesFields) {
        if (!query.contains(" project ")) {
            return Lists.newArrayList(presentablesFields);
        }
        String projectPart = (String)Iterables.getLast((Iterable)Splitter.on((String)" project ").omitEmptyStrings().splitToList((CharSequence)query));
        List projections = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().splitToList((CharSequence)projectPart);
        if (projections.size() == 1 && ((String)projections.get(0)).equals("*")) {
            return Lists.newArrayList(presentablesFields);
        }
        return Lists.newArrayList((Iterable)projections);
    }

    public String replaceFields(String query, Map<String, String> fields) {
        String newQuery = query;
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String fieldID = entry.getKey();
            String fieldName = entry.getValue();
            newQuery = newQuery.replace(fieldID, fieldName);
        }
        return newQuery;
    }

    public static void main(String[] args) {
        QueryParserHelper qh = new QueryParserHelper();
        String query = "select 1 2 from table project 1 2 3 4  S";
        HashMap fieldsMapping = Maps.newHashMap();
        fieldsMapping.put("1", "name");
        fieldsMapping.put("2", "age");
        System.out.println("query part     : " + qh.getQueryPart("select 1 2 from table project 1 2 3 4  S"));
        System.out.println("project part   : " + qh.getProjectPart("select 1 2 from table project 1 2 3 4  S", (List)Lists.newArrayList(fieldsMapping.keySet())));
        System.out.println("replaced query : " + qh.replaceFields("select 1 2 from table project 1 2 3 4  S", (Map)fieldsMapping));
        List projections = qh.getProjectPart("select 1 2 from table project 1 2 3 4  S", (List)Lists.newArrayList(fieldsMapping.keySet()));
        System.out.println("projections : " + projections);
        if (projections.contains("S")) {
            projections.remove("S");
            projections.add("description");
        }
        System.out.println("projections : " + projections);
    }
}

