/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.consumer.service.resources;

import com.google.common.io.Resources;
import com.google.gson.Gson;
import java.io.InputStream;
import java.util.Properties;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourceawareservice.resources.StatefulResource;
import org.gcube.rest.commons.resourceawareservice.resources.exceptions.StatefulResourceException;
import org.gcube.search.sru.consumer.common.resources.SruConsumerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SruConsumerResourceFactory
extends ResourceFactory<SruConsumerResource> {
    private static final Logger logger = LoggerFactory.getLogger(SruConsumerResourceFactory.class);
    private static final String SCOPE_PROP = "scope";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getScope() {
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
            String string = properties.getProperty(SCOPE_PROP);
            return string;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHostname() {
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
            String string = properties.getProperty("hostname");
            return string;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
    }

    public SruConsumerResource createResource(String resourceID, String params) throws StatefulResourceException {
        SruConsumerResource resource = (SruConsumerResource)new Gson().fromJson(params, SruConsumerResource.class);
        if (resource.getScope() != null && !resource.getScope().equalsIgnoreCase(this.getScope())) {
            logger.error("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
            throw new StatefulResourceException("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
        }
        resource.setResourceID(resourceID);
        resource.setHostname(this.getHostname());
        return resource;
    }

    public void loadResource(SruConsumerResource resource) throws StatefulResourceException {
        super.loadResource((StatefulResource)resource);
        resource.setHostname(this.getHostname());
    }
}

