/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.admin;

import gr.forth.ics.isl.textentitymining.gate.addcategory.AddCategory;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.TreeSet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AddNewCategory
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        HttpSession session = request.getSession();
        String loggedin = (String)session.getAttribute("loggedin");
        if (loggedin == null) {
            loggedin = "no";
            session.setAttribute("loggedin", (Object)loggedin);
            RequestDispatcher dispatcher = request.getRequestDispatcher("login.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        PrintWriter out = response.getWriter();
        out.print("");
        try {
            String[] words;
            String categoryName = request.getParameter("categoryName");
            if (categoryName == null) {
                categoryName = "";
            }
            if (categoryName.trim().equals("")) {
                out.print("You must give a category name!");
                out.close();
                return;
            }
            String list = request.getParameter("list");
            if (list == null) {
                list = "";
            }
            list = URLDecoder.decode(list, "utf-8");
            TreeSet<String> wordsSet = new TreeSet<String>();
            for (String word : words = list.split("\n")) {
                if ((word = word.trim()).equals("")) continue;
                wordsSet.add(word);
            }
            if (wordsSet.isEmpty()) {
                out.print("You must give a set of words or phrases!");
                out.close();
                return;
            }
            System.out.println("# Initial category name: " + categoryName);
            categoryName = categoryName.replaceAll("[^a-zA-Z0-9]+", "_");
            System.out.println("# Final category name: " + categoryName);
            System.out.println("# Number of words/phrases: " + wordsSet.size());
            AddCategory addCategory = new AddCategory(categoryName, wordsSet);
            addCategory.add();
            Resources.MINING_ALL_POSSIBLE_CATEGORIES.add(categoryName);
            Properties prop = new Properties();
            FileInputStream in = new FileInputStream(Resources.X_SEARCH_PROPERTIES_FILE);
            prop.load(in);
            String propertyValue = "";
            for (String cat : Resources.MINING_ALL_POSSIBLE_CATEGORIES) {
                propertyValue = propertyValue + cat.trim();
                propertyValue = propertyValue + ",";
            }
            prop.setProperty("gr.forth.ics.isl.xsearch.resources.mining.allPossibleCategories", propertyValue.substring(0, propertyValue.length() - 1));
            prop.store(new FileOutputStream(new File(Resources.X_SEARCH_PROPERTIES_FILE)), "X-Search Properties");
        }
        catch (Exception e) {
            out.print(e.getMessage().replace("\n", " "));
        }
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

