/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.inspecting;

import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.inspecting.SparqlRunner;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class InspectEntity
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HashMap templateQueries;
        HashMap endpoints;
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        HttpSession session = request.getSession();
        HashSet acceptedCategories = (HashSet)session.getAttribute("acceptedCategories");
        if (acceptedCategories == null) {
            acceptedCategories = Resources.MINING_ACCEPTED_CATEGORIES;
        }
        if ((endpoints = (HashMap)session.getAttribute("endpoints")) == null) {
            endpoints = Resources.SPARQL_ENDPOINTS;
        }
        if ((templateQueries = (HashMap)session.getAttribute("templateQueries")) == null) {
            templateQueries = Resources.SPARQL_TEMPLATES;
        }
        try {
            SparqlRunner existingRunner = (SparqlRunner)session.getAttribute("sparqlRunnerThread");
            if (existingRunner != null) {
                System.out.println("# Stopping previous SPARQL runner...");
                existingRunner.interrupt();
                existingRunner.stop();
                System.out.println("# The previous SPARQL runner was stopped!");
                session.removeAttribute("sparqlRunnerThread");
            }
            long start = System.currentTimeMillis();
            System.out.println("# Inspecting selected entity...");
            String category = request.getParameter("category");
            String element = request.getParameter("element");
            element = element.replace("^^^^^", "%");
            String bubbleid = "bubble" + request.getParameter("rand");
            SparqlRunner runner = new SparqlRunner(category, element, acceptedCategories, endpoints, templateQueries);
            runner.start();
            session.setAttribute("sparqlRunnerThread", (Object)runner);
            boolean finish = false;
            while (!finish && !runner.finish) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ex) {
                    IOSLog.writeErrorToLog((Exception)ex, (String)"InspectEntity");
                    System.out.println("*** ERROR WHILE TRYING TO SLEEP FOR ONE SECOND!");
                }
            }
            ArrayList results = runner.getResultsData();
            if (results.isEmpty()) {
                out.print("<h3><center>Sorry!<br />No information for this entity!</center></h3>");
            } else {
                for (HashMap resultMap : results) {
                    for (String variableName : resultMap.keySet()) {
                        String variableValue = (String)resultMap.get(variableName);
                        out.print("<font class=\"lod_data\">");
                        out.print("&bull;&nbsp;<b>" + variableName + ":</b> ");
                        if (variableValue.toLowerCase().startsWith("http")) {
                            String displayValue = variableValue;
                            if (displayValue.length() > 100) {
                                displayValue = displayValue.substring(0, 99) + "...";
                            }
                            String passvariableValue = variableValue.replace("#", "[NUMBERSIGN]");
                            String href = "javascript:showProperties(\"" + category + "\", \"" + URLEncoder.encode(passvariableValue, "utf8") + "\", \"" + bubbleid + "\");";
                            out.print("<a title='" + displayValue + "' href='" + href + "'>" + displayValue + "</a>");
                            out.print("&nbsp;&nbsp;<a href='" + variableValue + "' target='_blank' class='em_minepage'>(open)</a>");
                        } else {
                            out.print(variableValue);
                        }
                        out.print("<br />");
                        out.print("</font>");
                    }
                    out.print("<hr />");
                }
            }
            long end = System.currentTimeMillis() - start;
            System.out.println("# TIME RETRIEVING LOD: " + end + " ms.");
            String query = (String)session.getAttribute("submitted_query");
            this.updateLog(request, query, category, element, end);
        }
        finally {
            out.close();
        }
    }

    public void updateLog(HttpServletRequest request, String query, String category, String entity, long time) {
        String ip = request.getRemoteAddr();
        String date = IOSLog.getCurrentDate();
        String line = "\nx-search\t" + date + "\t" + ip + "\t" + query + "\tINSPECT_LOD ENTITY='" + entity + "' CATEGORY='" + category + "' TIME=" + time + "ms";
        IOSLog.writeToLog((String)line);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

