/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class HTMLTag {
    private String sourceCode = "";
    private URL url;
    private URLConnection con;
    private BufferedReader in;
    private boolean error = false;

    public HTMLTag(URL theUrl) {
        this.url = theUrl;
        try {
            this.con = this.url.openConnection();
            this.con.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; H010818)");
            this.con.setConnectTimeout(90000);
            this.con.setReadTimeout(90000);
            this.in = new BufferedReader(new InputStreamReader(this.con.getInputStream(), "UTF-8"));
            if (this.con.getContentType().toLowerCase().contains("text/html")) {
                if (this.in != null) {
                    String input;
                    while ((input = this.in.readLine()) != null) {
                        this.sourceCode = this.sourceCode + input + "\n";
                    }
                    this.in.close();
                } else {
                    this.sourceCode = "";
                }
            } else {
                this.sourceCode = "";
            }
        }
        catch (IOException ex) {
            System.out.println("*** ERROR READING URL: " + ex.getMessage());
            this.sourceCode = "";
            this.error = true;
        }
    }

    public HTMLTag(URL theUrl, boolean xmlContent) {
        this.url = theUrl;
        try {
            this.con = this.url.openConnection();
            this.con.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; H010818)");
            this.con.setConnectTimeout(90000);
            this.con.setReadTimeout(90000);
            this.in = new BufferedReader(new InputStreamReader(this.con.getInputStream(), "UTF-8"));
            if (this.in != null) {
                String input;
                while ((input = this.in.readLine()) != null) {
                    this.sourceCode = this.sourceCode + input + "\n";
                }
                this.in.close();
            } else {
                this.sourceCode = "";
            }
        }
        catch (IOException ex) {
            System.out.println("*** ERROR READING URL: " + ex.getMessage());
            this.error = true;
        }
    }

    public HTMLTag(String theSourceCode) {
        if (theSourceCode == null) {
            System.out.println("Attention! Null String for HTMLTag object!");
            this.sourceCode = "";
        } else {
            this.sourceCode = theSourceCode;
        }
    }

    public String getFirstTag() {
        int i1 = this.sourceCode.indexOf("<", 0);
        if (i1 == -1) {
            return null;
        }
        int i2 = this.sourceCode.indexOf(">", i1);
        if (i2 == -1) {
            return null;
        }
        int i3 = this.sourceCode.indexOf(" ", i1);
        if (i3 == -1) {
            return this.sourceCode.substring(i1 + 1, i2);
        }
        if (i2 < i3) {
            return this.sourceCode.substring(i1 + 1, i2);
        }
        return this.sourceCode.substring(i1 + 1, i3);
    }

    public String getFirstTag(int fromIndex) {
        int i1 = this.sourceCode.indexOf("<", fromIndex);
        if (i1 == -1) {
            return null;
        }
        int i2 = this.sourceCode.indexOf(">", i1);
        if (i2 == -1) {
            return null;
        }
        int i3 = this.sourceCode.indexOf(" ", i1);
        if (i3 == -1) {
            return this.sourceCode.substring(i1 + 1, i2);
        }
        if (i2 < i3) {
            return this.sourceCode.substring(i1 + 1, i2);
        }
        return this.sourceCode.substring(i1 + 1, i3);
    }

    public int getFirstTagIndex(String theTag) {
        int i1 = this.sourceCode.indexOf("<");
        while (i1 != -1) {
            int i2 = this.sourceCode.indexOf(">", i1);
            if (i2 == -1) {
                return -1;
            }
            int i3 = this.sourceCode.indexOf(" ", i1);
            if (i3 == -1) {
                if (this.sourceCode.substring(i1 + 1, i2).toUpperCase().compareTo(theTag.toUpperCase()) == 0) {
                    return i1;
                }
                i1 = this.sourceCode.indexOf("<", i1 + 1);
                continue;
            }
            if (i2 < i3) {
                if (this.sourceCode.substring(i1 + 1, i2).toUpperCase().compareTo(theTag.toUpperCase()) == 0) {
                    return i1;
                }
                i1 = this.sourceCode.indexOf("<", i1 + 1);
                continue;
            }
            if (this.sourceCode.substring(i1 + 1, i3).toUpperCase().compareTo(theTag.toUpperCase()) == 0) {
                return i1;
            }
            i1 = this.sourceCode.indexOf("<", i1 + 1);
        }
        return -1;
    }

    public int getFirstTagIndex(String theTag, int fromIndex) {
        int i1 = this.sourceCode.indexOf("<", fromIndex);
        while (i1 != -1) {
            int i2 = this.sourceCode.indexOf(">", i1);
            if (i2 == -1) {
                return -1;
            }
            int i3 = this.sourceCode.indexOf(" ", i1);
            if (i3 == -1) {
                if (this.sourceCode.substring(i1 + 1, i2).toUpperCase().compareTo(theTag.toUpperCase()) == 0) {
                    return i1;
                }
                i1 = this.sourceCode.indexOf("<", i1 + 1);
                continue;
            }
            if (i2 < i3) {
                if (this.sourceCode.substring(i1 + 1, i2).toUpperCase().compareTo(theTag.toUpperCase()) == 0) {
                    return i1;
                }
                i1 = this.sourceCode.indexOf("<", i1 + 1);
                continue;
            }
            if (this.sourceCode.substring(i1 + 1, i3).toUpperCase().compareTo(theTag.toUpperCase()) == 0) {
                return i1;
            }
            i1 = this.sourceCode.indexOf("<", i1 + 1);
        }
        return -1;
    }

    public int getFirstTagIndexContains(String theTag, String containment) {
        int index = this.getFirstTagIndex(theTag);
        String tagContent = this.getFirstTagContent(theTag, index);
        while (index != -1) {
            if (tagContent == null) {
                index = this.getFirstTagIndex(theTag, index + 1);
                tagContent = this.getFirstTagContent(theTag, index);
                continue;
            }
            if (tagContent.toUpperCase().contains(containment.toUpperCase())) {
                return index;
            }
            index = this.getFirstTagIndex(theTag, index + 1);
            tagContent = this.getFirstTagContent(theTag, index);
        }
        return -1;
    }

    public int getFirstTagIndexContains(String theTag, String containment, int fromIndex) {
        int index = this.getFirstTagIndex(theTag, fromIndex);
        String tagContent = this.getFirstTagContent(theTag, index);
        while (index != -1) {
            if (tagContent == null) {
                index = this.getFirstTagIndex(theTag, index + 1);
                tagContent = this.getFirstTagContent(theTag, index);
                continue;
            }
            if (tagContent.toUpperCase().contains(containment.toUpperCase())) {
                return index;
            }
            index = this.getFirstTagIndex(theTag, index + 1);
            tagContent = this.getFirstTagContent(theTag, index);
        }
        return -1;
    }

    public int getFirstTagIndexContentEquals(String theTag, String containment) {
        int index = this.getFirstTagIndex(theTag, 0);
        String tagContent = this.getFirstTagContent(theTag, index);
        while (index != -1) {
            if (tagContent == null) {
                return -1;
            }
            if (tagContent.toUpperCase().contentEquals(containment.toUpperCase())) {
                return index;
            }
            index = this.getFirstTagIndex(theTag, index + 1);
            tagContent = this.getFirstTagContent(theTag, index + 1);
        }
        return -1;
    }

    public int getFirstTagIndexContentEquals(String theTag, String containment, int fromIndex) {
        int index = this.getFirstTagIndex(theTag, fromIndex);
        String tagContent = this.getFirstTagContent(theTag, index);
        while (index != -1) {
            if (tagContent == null) {
                return -1;
            }
            if (tagContent.toUpperCase().contentEquals(containment.toUpperCase())) {
                return index;
            }
            index = this.getFirstTagIndex(theTag, index + 1);
            tagContent = this.getFirstTagContent(theTag, index + 1);
        }
        return -1;
    }

    public String getFirstTagContent(String theTag) {
        int i1 = this.getFirstTagIndex(theTag);
        if (i1 == -1) {
            return null;
        }
        int i2 = this.sourceCode.indexOf(">", i1);
        int i3 = this.sourceCode.indexOf(" ", i1);
        if (i3 == -1) {
            return null;
        }
        if (i2 == -1) {
            return null;
        }
        if (i2 < i3) {
            return "";
        }
        return this.sourceCode.substring(i3 + 1, i2);
    }

    public String getFirstTagContent(String theTag, int fromIndex) {
        int i1 = this.getFirstTagIndex(theTag, fromIndex);
        if (i1 == -1) {
            return null;
        }
        int i2 = this.sourceCode.indexOf(">", i1);
        int i3 = this.sourceCode.indexOf(" ", i1);
        if (i3 == -1) {
            return null;
        }
        if (i2 == -1) {
            return null;
        }
        if (i2 < i3) {
            return "";
        }
        return this.sourceCode.substring(i3 + 1, i2);
    }

    public String getFirstTagContentContains(String theTag, String containment) {
        int i1 = this.getFirstTagIndexContains(theTag, containment);
        if (i1 != -1) {
            return this.getFirstTagContent(theTag, i1);
        }
        return null;
    }

    public String getFirstTagContentContains(String theTag, String containment, int fromIndex) {
        int i1 = this.getFirstTagIndexContains(theTag, containment, fromIndex);
        if (i1 != -1) {
            return this.getFirstTagContent(theTag, i1);
        }
        return null;
    }

    public String getFirstTagData(String theTag) {
        int i1 = this.getFirstTagIndex(theTag);
        if (i1 == -1) {
            return null;
        }
        int i2 = this.sourceCode.indexOf(">", i1);
        if (i2 == -1) {
            return null;
        }
        int i3 = this.getFirstTagIndex("/" + theTag, i2);
        if (i3 == -1) {
            return null;
        }
        int i4 = this.getFirstTagIndex(theTag, i2);
        if (i4 == -1) {
            return this.sourceCode.substring(i2 + 1, i3);
        }
        if (i3 < i4) {
            return this.sourceCode.substring(i2 + 1, i3);
        }
        while (i3 > i4) {
            i3 = this.getFirstTagIndex("/" + theTag, i3 + 2);
            i4 = this.getFirstTagIndex(theTag, i4 + 1);
            if (i3 == -1) {
                return null;
            }
            if (i4 == -1) {
                return this.sourceCode.substring(i2 + 1, i3);
            }
            if (i3 >= i4) continue;
            return this.sourceCode.substring(i2 + 1, i3);
        }
        return null;
    }

    public String getFirstTagData(String theTag, int fromIndex) {
        int i1 = this.getFirstTagIndex(theTag, fromIndex);
        if (i1 == -1) {
            return null;
        }
        int i2 = this.sourceCode.indexOf(">", i1);
        if (i2 == -1) {
            return null;
        }
        int i3 = this.getFirstTagIndex("/" + theTag, i2);
        if (i3 == -1) {
            return null;
        }
        int i4 = this.getFirstTagIndex(theTag, i2);
        if (i4 == -1) {
            return this.sourceCode.substring(i2 + 1, i3);
        }
        if (i3 < i4) {
            return this.sourceCode.substring(i2 + 1, i3);
        }
        while (i3 > i4) {
            i3 = this.getFirstTagIndex("/" + theTag, i3 + 2);
            i4 = this.getFirstTagIndex(theTag, i4 + 1);
            if (i3 == -1) {
                return null;
            }
            if (i4 == -1) {
                return this.sourceCode.substring(i2 + 1, i3);
            }
            if (i3 >= i4) continue;
            return this.sourceCode.substring(i2 + 1, i3);
        }
        return null;
    }

    public String getFirstTagDataContains(String theTag, String containment) {
        int i1 = this.getFirstTagIndexContains(theTag, containment);
        if (i1 != -1) {
            return this.getFirstTagData(theTag, i1);
        }
        return null;
    }

    public String getFirstTagDataContains(String theTag, String containment, int fromIndex) {
        int i1 = this.getFirstTagIndexContains(theTag, containment, fromIndex);
        if (i1 != -1) {
            return this.getFirstTagData(theTag, i1);
        }
        return null;
    }

    public String getFirstTagDataContentEquals(String theTag, String containment) {
        int i1 = this.getFirstTagIndexContentEquals(theTag, containment);
        if (i1 != -1) {
            return this.getFirstTagContent(theTag, i1);
        }
        return null;
    }

    public String getFirstTagDataContentEquals(String theTag, String containment, int fromIndex) {
        int i1 = this.getFirstTagIndexContentEquals(theTag, containment, fromIndex);
        if (i1 != -1) {
            return this.getFirstTagContent(theTag, i1);
        }
        return null;
    }

    public int getNumOfTags(String theTag) {
        int fromIndex = 0;
        int toIndex = this.sourceCode.length();
        int i1 = this.getFirstTagIndex(theTag, fromIndex);
        if (i1 == -1) {
            return 0;
        }
        if (i1 > toIndex) {
            return 0;
        }
        int sum = 1;
        while (i1 <= toIndex && (i1 = this.getFirstTagIndex(theTag, i1 + 1)) != -1) {
            if (i1 > toIndex) continue;
            ++sum;
        }
        return sum;
    }

    public int getNumOfTags(String theTag, int fromIndex) {
        int i1 = this.getFirstTagIndex(theTag, fromIndex);
        int toIndex = this.sourceCode.length();
        if (i1 == -1) {
            return 0;
        }
        if (i1 > toIndex) {
            return 0;
        }
        int sum = 1;
        while (i1 <= toIndex && (i1 = this.getFirstTagIndex(theTag, i1 + 1)) != -1) {
            if (i1 > toIndex) continue;
            ++sum;
        }
        return sum;
    }

    public int getNumOfTags(String theTag, int fromIndex, int toIndex) {
        int i1 = this.getFirstTagIndex(theTag, fromIndex);
        if (i1 == -1) {
            return 0;
        }
        if (i1 > toIndex) {
            return 0;
        }
        int sum = 1;
        while (i1 <= toIndex && (i1 = this.getFirstTagIndex(theTag, i1 + 1)) != -1) {
            if (i1 > toIndex) continue;
            ++sum;
        }
        return sum;
    }

    public String getDataFromTagToTag(String tag1, String tag2) {
        int i1 = this.getFirstTagIndex(tag1);
        int i2 = this.getFirstTagIndex(tag2, i1);
        if (i1 == -1) {
            return null;
        }
        if (i2 == -1) {
            return null;
        }
        int i3 = this.sourceCode.indexOf(">", i1);
        return this.sourceCode.substring(i3 + 1, i2);
    }

    public String getDataFromTagToTag(String tag1, String tag2, int fromIndex) {
        String fromTag = tag1;
        String toTag = tag2;
        int i1 = this.getFirstTagIndex(fromTag, fromIndex);
        int i2 = this.getFirstTagIndex(toTag, i1);
        if (i1 == -1) {
            return null;
        }
        if (i2 == -1) {
            return null;
        }
        return this.sourceCode.substring(i1, i2);
    }

    public static String removeTags(String text) {
        if (text == null) {
            return null;
        }
        int i1 = text.indexOf("<");
        if (i1 == -1) {
            return text;
        }
        while (i1 != -1) {
            int i2 = text.indexOf(">", i1);
            if (i2 == -1) {
                return text;
            }
            String aux1 = text.substring(i1, i2 + 1);
            text = text.replace(aux1, "");
            i1 = text.indexOf("<");
        }
        return text;
    }

    public static String removeTagButNoText(String tag, String text) {
        if (text == null) {
            return null;
        }
        int i1 = text.toLowerCase().indexOf("<" + tag.toLowerCase());
        if (i1 == -1) {
            return text;
        }
        while (i1 != -1) {
            int i2 = text.indexOf(">", i1);
            if (i2 == -1) {
                return text;
            }
            String aux1 = text.substring(i1, i2 + 1);
            text = text.replace(aux1, "");
            i1 = text.indexOf("<" + tag.toLowerCase());
        }
        text = text.replace("</" + tag.toLowerCase() + ">", "");
        return text;
    }

    public static String removeTag(String tag, String text) {
        if (tag == null) {
            return null;
        }
        HTMLTag tagger = new HTMLTag(text);
        int pos = tagger.getFirstTagIndex(tag);
        while (pos != -1) {
            String data_to_remove = tagger.getFirstTagData(tag, pos - 1);
            if (data_to_remove == null) {
                data_to_remove = "";
            }
            text = text.replace(data_to_remove, "");
            tagger = new HTMLTag(text);
            pos = tagger.getFirstTagIndex(tag, pos + 2);
        }
        return text;
    }

    public static String removeTagsNoTagB(String text) {
        if (text == null) {
            return null;
        }
        int i1 = text.indexOf(60);
        if (i1 == -1) {
            return text;
        }
        while (i1 != -1) {
            int i2 = text.indexOf(62, i1);
            if (i2 == -1) {
                return text;
            }
            String aux1 = text.substring(i1, i2 + 1);
            if (aux1.toUpperCase().equals("<B>") || aux1.toUpperCase().equals("</B>") || aux1.toUpperCase().equals("<STRONG>") || aux1.toUpperCase().equals("</STRONG>")) {
                i1 = text.indexOf(60, i2);
                continue;
            }
            text = text.replace(aux1, "");
            i1 = text.indexOf(60);
        }
        return text;
    }

    public static String getHref(String tagA) {
        String href = "HREF=";
        int i1 = tagA.toUpperCase().indexOf(href);
        if (i1 == -1) {
            return null;
        }
        if (tagA.charAt(i1 + 5) == '\"') {
            int i2 = tagA.indexOf("\"", i1 + 6);
            if (i2 == -1) {
                return null;
            }
            return tagA.substring(i1 + 6, i2);
        }
        int i2 = tagA.indexOf(" ", i1 + 6);
        if (i2 == -1) {
            return null;
        }
        return tagA.substring(i1 + 5, i2);
    }

    public static String getContentAttribute(String attr, String tagContent) {
        int i1 = tagContent.toLowerCase().indexOf(attr.toLowerCase());
        if (i1 == -1) {
            return null;
        }
        boolean other = false;
        int i2 = tagContent.indexOf("\"", i1 + 1);
        if (i2 == -1) {
            i2 = tagContent.indexOf("'", i1 + 1);
            other = true;
        }
        int i3 = !other ? tagContent.indexOf("\"", i2 + 1) : tagContent.indexOf("'", i2 + 1);
        if (i2 == -1 || i3 == -1) {
            return null;
        }
        return tagContent.substring(i2 + 1, i3);
    }

    public static String readFile(String filepath) {
        String contents = "";
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filepath), "UTF8"));
            while ((line = in.readLine()) != null) {
                contents = contents + line + "\n";
            }
            in.close();
        }
        catch (Exception ex) {
            System.out.println("ERROR READING FILE '" + filepath + "'\n: " + ex.getMessage());
        }
        return contents;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }
}

