/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.social_networking_client_library;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.GenericType;
import org.apache.commons.lang.Validate;
import org.gcube.social_networking.social_networking_client_library.BaseClient;
import org.gcube.social_networking.social_networking_client_library.utils.HttpClient;
import org.gcube.social_networking.socialnetworking.model.beans.UserProfileExtended;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserClient
extends BaseClient {
    private static final String SUB_SERVICE_PATH = "2/users/";
    private static Logger logger = LoggerFactory.getLogger(UserClient.class);

    public UserClient() throws Exception {
        super(SUB_SERVICE_PATH);
    }

    public String getCustomAttribute(String attributeKey) {
        Validate.isTrue((attributeKey != null ? 1 : 0) != 0, (String)"attribute key cannot be null");
        logger.debug("Request for attribute value");
        String thisMethodSignature = "get-custom-attribute";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?attribute=" + attributeKey;
        return HttpClient.get(new GenericType<ResponseBean<String>>(){}, request);
    }

    public String getFullName() {
        logger.debug("Request for fullname");
        String thisMethodSignature = "get-fullname";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<String>>(){}, request);
    }

    public String getEmail() {
        logger.debug("Request for email");
        String thisMethodSignature = "get-email";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<String>>(){}, request);
    }

    public UserProfileExtended getProfile() {
        logger.debug("Request for getting profile");
        String thisMethodSignature = "get-profile";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<UserProfileExtended>>(){}, request);
    }

    public List<String> getAllUsernamesContext() {
        logger.debug("Request for getting usernames in this context");
        String thisMethodSignature = "get-all-usernames";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<String>>>(){}, request);
    }

    public Map<String, String> getAllUsernamesFullnamesContext() {
        logger.debug("Request for getting usernames and fullnames in this context");
        String thisMethodSignature = "get-all-fullnames-and-usernames";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<HashMap<String, String>>>(){}, request);
    }

    public List<String> getAllUsernamesByGlobalRole(String globalRole) {
        Validate.isTrue((globalRole != null ? 1 : 0) != 0, (String)"role cannot be null");
        logger.debug("Request for getting usernames with global role");
        String thisMethodSignature = "get-usernames-by-global-role";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?role-name=" + globalRole;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<String>>>(){}, request);
    }

    @Deprecated
    public List<String> getAllUsernamesByLocalRole(String localRole) {
        Validate.isTrue((localRole != null ? 1 : 0) != 0, (String)"role cannot be null");
        logger.debug("Request for getting usernames by role role");
        String thisMethodSignature = "get-usernames-by-role";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?role-name=" + localRole;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<String>>>(){}, request);
    }

    public Set<String> getAllUsernamesByRole(String rolename) {
        Validate.isTrue((rolename != null ? 1 : 0) != 0, (String)"role cannot be null");
        logger.debug("Request for getting usernames with global role");
        String thisMethodSignature = "get-usernames-by-role";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?role-name=" + rolename;
        ArrayList<String> sourceList = HttpClient.get(new GenericType<ResponseBean<ArrayList<String>>>(){}, request);
        HashSet<String> usernames = new HashSet<String>(sourceList);
        return usernames;
    }

    public Boolean userExists(String username) {
        Validate.isTrue((username != null ? 1 : 0) != 0, (String)"username cannot be null");
        logger.debug("Request for getting usernames with global role");
        String thisMethodSignature = "user-exists";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?username=" + username;
        return HttpClient.get(new GenericType<ResponseBean<Boolean>>(){}, request);
    }
}

