/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.clients.geoserver;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import javax.ws.rs.client.Entity;
import org.gcube.spatial.data.clients.AbstractGenericRESTClient;
import org.gcube.spatial.data.clients.GenericLoginClient;
import org.gcube.spatial.data.clients.geoserver.GSRESTClient;
import org.gcube.spatial.data.clients.model.ConnectionDescriptor;
import org.gcube.spatial.data.sdi.model.faults.RemoteException;
import org.gcube.spatial.data.sdi.model.gn.LoginLevel;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSRESTClientImpl
extends AbstractGenericRESTClient
implements GSRESTClient,
GenericLoginClient {
    private static final Logger log = LoggerFactory.getLogger(GSRESTClientImpl.class);
    private static final String API_BASE_PATH = "rest";
    private static final String WS_BASE_PATH = "workspaces";
    private static final String DATASTORE_BASE_PATH = "datastores";
    private static final String STYLES_BASE_PATH = "styles";
    private static final String LAYERS_BASE_PATH = "layers";
    static Configuration JSON_PATH_ALWAYS_LIST_CONFIG = Configuration.builder().options(new Option[]{Option.ALWAYS_RETURN_LIST, Option.SUPPRESS_EXCEPTIONS, Option.DEFAULT_PATH_LEAF_TO_NULL}).build();

    public GSRESTClientImpl(ConnectionDescriptor conn) {
        super(conn);
        this.setBasePath(API_BASE_PATH);
    }

    public void login() {
    }

    public void login(LoginLevel lvl) {
    }

    @Override
    public JSONObject getWorkspaces() throws RemoteException, Exception {
        return this.get(WS_BASE_PATH);
    }

    @Override
    public JSONObject getWorkspace(String workspace) throws RemoteException, Exception {
        return this.get("workspaces/" + workspace);
    }

    @Override
    public JSONObject getDataStoresInWorkspace(String ws) throws RemoteException, Exception {
        return this.get("workspaces/" + ws + "/datastores");
    }

    @Override
    public JSONObject getStyles() throws RemoteException, Exception {
        return this.get(STYLES_BASE_PATH);
    }

    @Override
    public JSONObject getStylesByLayer(String layer) throws RemoteException, Exception {
        return this.get("layers/" + layer + "/styles");
    }

    @Override
    public JSONObject getStylesInWorkspace(String ws) throws RemoteException, Exception {
        return this.get("workspaces/" + ws + "/styles");
    }

    @Override
    public List<String> getWorkspaceNames() throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.getWorkspaces().toString());
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public List<String> getDataStoresNamesInWorkspace(String ws) throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.getDataStoresInWorkspace(ws).toString());
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public List<String> getStylesNames() throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.getStyles().toString());
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public List<String> getStylesNamesinWorkspace(String ws) throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.getStylesInWorkspace(ws).toString());
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public List<String> getStylesNamesByLayer(String layer) throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.getStylesByLayer(layer).toString());
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public void deleteWorkspace(String ws) throws RemoteException, Exception {
        this.delete("workspaces/" + ws);
    }

    @Override
    public void deleteStyle(String style) throws RemoteException, Exception {
        this.delete("styles/" + style);
    }

    @Override
    public void deleteDataStore(String ds) throws RemoteException, Exception {
        this.delete("datastores/" + ds);
    }

    @Override
    public void deleteLayer(String layer) throws RemoteException, Exception {
        this.delete("layers/" + layer);
    }

    @Override
    public void createWorkspace(String ws) throws RemoteException, Exception {
        this.post(WS_BASE_PATH, Entity.entity((Object)new JSONObject().put((Object)"name", (Object)ws), (String)"application/json"));
    }
}

