package org.gcube.spatial.data.clients.geoserver;

import java.util.ArrayList;
import java.util.Map;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.json.simple.JSONObject;

import lombok.AllArgsConstructor;
import lombok.Data;

@Data
@XmlRootElement(name = "datastore")
public class DataStoreRegistrationRequest {

	@Data
	@AllArgsConstructor
	private static class Parameter{
		private String key;
		 @XmlElement(name="$")
		private String value;
	}
	
	private JSONObject datastore=new JSONObject();
	
	public DataStoreRegistrationRequest() {		
	}
	
	public DataStoreRegistrationRequest(String name) {
		setName(name);
	}
	
	public void setName(String name) {
		datastore.put("name",name);
	}
	
	public void setParameters(Map<String,String> params) {
		ArrayList<Parameter> paramList=new ArrayList<Parameter>();
		
		params.forEach((String k,String v)->{paramList.add(new Parameter(k,v));});
		
		datastore.put("connectionParameters", new JSONObject().put("entry", paramList));
		
	}
	
	
}
