/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.clients.geoserver.model;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.json.simple.JSONObject;

@XmlRootElement(name="datastore")
public class DataStoreRegistrationRequest {
    private JSONObject datastore = new JSONObject();
    private ArrayList<Parameter> paramList = new ArrayList();

    public DataStoreRegistrationRequest() {
    }

    public DataStoreRegistrationRequest(String name) {
        this.setName(name);
    }

    public DataStoreRegistrationRequest(String name, Map<String, String> params) {
        this.setName(name);
        this.setParameters(params);
    }

    public DataStoreRegistrationRequest setName(String name) {
        this.datastore.put((Object)"name", (Object)name);
        return this;
    }

    public DataStoreRegistrationRequest setParameters(Map<String, String> params) {
        params.forEach((k, v) -> this.paramList.add(new Parameter((String)k, (String)v)));
        this.datastore.put((Object)"connectionParameters", (Object)new JSONObject(Collections.singletonMap("entry", this.paramList)));
        return this;
    }

    public DataStoreRegistrationRequest param(String key, String value) {
        this.paramList.add(new Parameter(key, value));
        this.datastore.put((Object)"connectionParameters", (Object)new JSONObject(Collections.singletonMap("entry", this.paramList)));
        return this;
    }

    public JSONObject getDatastore() {
        return this.datastore;
    }

    public ArrayList<Parameter> getParamList() {
        return this.paramList;
    }

    public void setDatastore(JSONObject datastore) {
        this.datastore = datastore;
    }

    public void setParamList(ArrayList<Parameter> paramList) {
        this.paramList = paramList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataStoreRegistrationRequest)) {
            return false;
        }
        DataStoreRegistrationRequest other = (DataStoreRegistrationRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JSONObject this$datastore = this.getDatastore();
        JSONObject other$datastore = other.getDatastore();
        if (this$datastore == null ? other$datastore != null : !this$datastore.equals(other$datastore)) {
            return false;
        }
        ArrayList<Parameter> this$paramList = this.getParamList();
        ArrayList<Parameter> other$paramList = other.getParamList();
        return !(this$paramList == null ? other$paramList != null : !((Object)this$paramList).equals(other$paramList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataStoreRegistrationRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JSONObject $datastore = this.getDatastore();
        result = result * 59 + ($datastore == null ? 0 : $datastore.hashCode());
        ArrayList<Parameter> $paramList = this.getParamList();
        result = result * 59 + ($paramList == null ? 0 : ((Object)$paramList).hashCode());
        return result;
    }

    public String toString() {
        return "DataStoreRegistrationRequest(datastore=" + this.getDatastore() + ", paramList=" + this.getParamList() + ")";
    }

    private static class Parameter {
        private String key;
        @XmlElement(name="$")
        private String value;

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter other = (Parameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 0 : $key.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 0 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "DataStoreRegistrationRequest.Parameter(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }

        @ConstructorProperties(value={"key", "value"})
        public Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

