/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis.symbology;

import java.awt.Color;
import java.awt.RenderingHints;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import javax.measure.unit.NonSI;
import javax.xml.bind.JAXBException;
import org.gcube.spatial.data.gis.symbology.ClassStyleDef;
import org.gcube.spatial.data.gis.symbology.GeometryType;
import org.gcube.spatial.data.gis.symbology.Range;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.sld.DefaultSLDFactory;
import org.geotoolkit.sld.MutableSLDFactory;
import org.geotoolkit.sld.xml.Specification;
import org.geotoolkit.sld.xml.XMLUtilities;
import org.geotoolkit.style.MutableFeatureTypeStyle;
import org.geotoolkit.style.MutableRule;
import org.geotoolkit.style.MutableStyle;
import org.geotoolkit.style.MutableStyleFactory;
import org.geotoolkit.style.StyleConstants;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Graphic;
import org.opengis.style.Mark;
import org.opengis.style.Style;

public class StyleUtils {
    protected static final FilterFactory FF = FactoryFinder.getFilterFactory(null);
    protected static final MutableSLDFactory SLDF = new DefaultSLDFactory();
    protected static final MutableStyleFactory SF = (MutableStyleFactory)FactoryFinder.getStyleFactory((Hints)new Hints((RenderingHints.Key)Hints.STYLE_FACTORY, MutableStyleFactory.class));
    protected static XMLUtilities utils = new XMLUtilities();

    @Deprecated
    public static String createStyle(String nameStyle, String attributeName, int maxClasses, Color c1, Color c2, Class typeValue, Object maxValue, Object minValue) throws Exception {
        return StyleUtils.createStyle(nameStyle, attributeName, maxClasses, c1, c2, typeValue, maxValue, minValue, true, GeometryType.POLYGON);
    }

    @Deprecated
    public static String createStyleLog(String nameStyle, String attributeName, int maxClasses, Color c1, Color c2, Class typeValue, Object maxValue, Object minValue) throws Exception {
        return StyleUtils.createStyle(nameStyle, attributeName, maxClasses, c1, c2, typeValue, maxValue, minValue, false, GeometryType.POLYGON);
    }

    @Deprecated
    public static String createStyleScatterColors(String nameStyle, String attributeName, int nClasses, Class typeValue, Object maxValue, Object minValue) throws Exception {
        return StyleUtils.createStyleScatterColors(nameStyle, attributeName, nClasses, typeValue, maxValue, minValue, true, GeometryType.POLYGON);
    }

    @Deprecated
    public static String createStyleLogScatterColors(String nameStyle, String attributeName, int nClasses, Class typeValue, Object maxValue, Object minValue) throws Exception {
        return StyleUtils.createStyleScatterColors(nameStyle, attributeName, nClasses, typeValue, maxValue, minValue, false, GeometryType.POLYGON);
    }

    @Deprecated
    public static String createStyle(String nameStyle, String attributeName, ArrayList<ClassStyleDef> classes, Color c1, Color c2) throws Exception {
        return StyleUtils.createStyle(nameStyle, attributeName, classes, c1, c2, GeometryType.POLYGON);
    }

    public static String createStyle(String nameStyle, String attributeName, int maxClasses, Color c1, Color c2, Class typeValue, Object maxValue, Object minValue, GeometryType geometryType) throws Exception {
        return StyleUtils.createStyle(nameStyle, attributeName, maxClasses, c1, c2, typeValue, maxValue, minValue, true, geometryType);
    }

    public static String createStyleLog(String nameStyle, String attributeName, int maxClasses, Color c1, Color c2, Class typeValue, Object maxValue, Object minValue, GeometryType geometryType) throws Exception {
        return StyleUtils.createStyle(nameStyle, attributeName, maxClasses, c1, c2, typeValue, maxValue, minValue, false, geometryType);
    }

    public static String createStyleScatterColors(String nameStyle, String attributeName, int nClasses, Class typeValue, Object maxValue, Object minValue, GeometryType geometryType) throws Exception {
        return StyleUtils.createStyleScatterColors(nameStyle, attributeName, nClasses, typeValue, maxValue, minValue, true, geometryType);
    }

    public static String createStyleLogScatterColors(String nameStyle, String attributeName, int nClasses, Class typeValue, Object maxValue, Object minValue, GeometryType geometryType) throws Exception {
        return StyleUtils.createStyleScatterColors(nameStyle, attributeName, nClasses, typeValue, maxValue, minValue, false, geometryType);
    }

    public static String createStyle(String nameStyle, String attributeName, ArrayList<ClassStyleDef> classes, Color c1, Color c2, GeometryType geometryType) throws Exception {
        if (classes.size() <= 0) {
            throw new Exception("Invalid number of classes!!");
        }
        MutableStyle style = SF.style();
        MutableFeatureTypeStyle fts = SF.featureTypeStyle();
        ArrayList<Color> colors = StyleUtils.scatterColor(classes.size());
        int i = 0;
        while (i < classes.size()) {
            ClassStyleDef classStyle = classes.get(i);
            switch (classStyle.getType()) {
                case RANGE: {
                    fts.rules().add(StyleUtils.makeRule(new Range(attributeName, colors.get(i), classStyle.getFrom(), classStyle.getTo(), Range.Condition.BETWEEN), geometryType));
                    break;
                }
                case SINGLE_VALUE: {
                    fts.rules().add(StyleUtils.makeRule(new Range(attributeName, colors.get(i), classStyle.getFrom(), null, Range.Condition.EQUALS), geometryType));
                }
            }
            ++i;
        }
        style.featureTypeStyles().add(fts);
        style.setName(nameStyle);
        return StyleUtils.marshall((Style)style);
    }

    private static String createStyle(String nameStyle, String attributeName, int maxClasses, Color c1, Color c2, Class typeValue, Object maxValue, Object minValue, boolean linear, GeometryType geometryType) throws Exception {
        if (maxClasses <= 0) {
            throw new Exception("Invalid number of classes!!");
        }
        MutableStyle style = SF.style();
        MutableFeatureTypeStyle fts = SF.featureTypeStyle();
        ArrayList<Range> ranges = StyleUtils.getRanges(typeValue, maxClasses, maxValue, minValue, attributeName, linear);
        ArrayList<Color> colors = StyleUtils.gradientColors(ranges.size(), c1, c2);
        int i = 0;
        while (i < ranges.size()) {
            ranges.get(i).setToAssignColor(colors.get(i));
            ++i;
        }
        for (Range r : ranges) {
            fts.rules().add(StyleUtils.makeRule(r, geometryType));
        }
        style.featureTypeStyles().add(fts);
        style.setName(nameStyle);
        return StyleUtils.marshall((Style)style);
    }

    private static String createStyleScatterColors(String nameStyle, String attributeName, int maxClasses, Class typeValue, Object maxValue, Object minValue, boolean linear, GeometryType geometryType) throws Exception {
        if (maxClasses <= 0) {
            throw new Exception("Invalid number of classes!!");
        }
        MutableStyle style = SF.style();
        MutableFeatureTypeStyle fts = SF.featureTypeStyle();
        ArrayList<Range> ranges = StyleUtils.getRanges(typeValue, maxClasses, maxValue, minValue, attributeName, linear);
        ArrayList<Color> colors = StyleUtils.scatterColor(ranges.size());
        int i = 0;
        while (i < ranges.size()) {
            ranges.get(i).setToAssignColor(colors.get(i));
            ++i;
        }
        for (Range r : ranges) {
            fts.rules().add(StyleUtils.makeRule(r, geometryType));
        }
        style.featureTypeStyles().add(fts);
        style.setName(nameStyle);
        return StyleUtils.marshall((Style)style);
    }

    private static String marshall(Style toMarshal) throws JAXBException {
        StringWriter writer = new StringWriter();
        utils.writeStyle((Object)writer, toMarshal, Specification.StyledLayerDescriptor.V_1_0_0);
        return writer.toString().replaceAll("<([a-zA-Z][a-zA-Z0-9:]*)[^>]*>\\s*</\\1>", "");
    }

    private static MutableRule makeRule(Range r, GeometryType geomType) {
        MutableRule toReturn = SF.rule();
        switch (r.getCondition()) {
            case BETWEEN: {
                toReturn.setFilter((Filter)FF.and((Filter)FF.greaterOrEqual((Expression)FF.property(r.getToFilterProperty()), (Expression)FF.literal(r.getMin())), (Filter)FF.less((Expression)FF.property(r.getToFilterProperty()), (Expression)FF.literal(r.getMax()))));
                toReturn.setName(String.valueOf(r.getToFilterProperty()) + " in [" + r.getMin() + " , " + r.getMax() + ")");
                break;
            }
            case GREATER_THEN_MIN: {
                toReturn.setFilter((Filter)FF.greaterOrEqual((Expression)FF.property(r.getToFilterProperty()), (Expression)FF.literal(r.getMin())));
                toReturn.setName(String.valueOf(r.getToFilterProperty()) + " = > " + r.getMin());
                break;
            }
            case UP_TO_MAX: {
                toReturn.setFilter((Filter)FF.lessOrEqual((Expression)FF.property(r.getToFilterProperty()), (Expression)FF.literal(r.getMax())));
                toReturn.setName(String.valueOf(r.getToFilterProperty()) + " < = " + r.getMin());
                break;
            }
            case EQUALS: {
                toReturn.setFilter((Filter)FF.equals((Expression)FF.property(r.getToFilterProperty()), (Expression)FF.literal(r.getMin())));
                toReturn.setName(String.valueOf(r.getToFilterProperty()) + " = " + r.getMin());
            }
        }
        switch (geomType) {
            case POINT: {
                Mark mark = SF.mark((Expression)StyleConstants.MARK_SQUARE, SF.fill(r.getToAssignColor()), null);
                Graphic graphic = SF.graphic(Collections.singletonList(mark), (Expression)StyleConstants.LITERAL_ONE_FLOAT, (Expression)FF.literal(5), (Expression)StyleConstants.LITERAL_ZERO_FLOAT, StyleConstants.DEFAULT_ANCHOR_POINT, StyleConstants.DEFAULT_DISPLACEMENT);
                toReturn.symbolizers().add(SF.pointSymbolizer(toReturn.getName(), "the_geom", StyleConstants.DEFAULT_DESCRIPTION, NonSI.PIXEL, graphic));
                break;
            }
            default: {
                toReturn.symbolizers().add(SF.polygonSymbolizer(toReturn.getName(), "the_geom", StyleConstants.DEFAULT_DESCRIPTION, NonSI.PIXEL, null, SF.fill(r.getToAssignColor()), StyleConstants.DEFAULT_DISPLACEMENT, (Expression)StyleConstants.LITERAL_ZERO_FLOAT));
            }
        }
        return toReturn;
    }

    private static ArrayList<Range> getRanges(Class typeValue, int maxClasses, Object maxValue, Object minValue, String attributeName, boolean linear) throws Exception {
        Double dMin;
        Double dMax;
        if (maxValue.getClass() != minValue.getClass()) {
            throw new Exception("Min (" + minValue.getClass() + ")and Max (" + maxValue.getClass() + ") value must be of same class");
        }
        boolean integerRanges = typeValue.isAssignableFrom(Integer.class);
        if (maxValue instanceof Double) {
            dMax = (Double)maxValue;
            dMin = (Double)minValue;
        } else if (maxValue instanceof Float) {
            dMax = new Double(((Float)maxValue).floatValue());
            dMin = new Double(((Float)minValue).floatValue());
        } else if (maxValue instanceof Integer) {
            dMax = (double)((Integer)maxValue).intValue() * 1.0;
            dMin = (double)((Integer)minValue).intValue() * 1.0;
        } else if (maxValue instanceof String) {
            dMax = Double.parseDouble((String)maxValue);
            dMin = Double.parseDouble((String)minValue);
        } else {
            throw new Exception("Unable to handle range values class " + maxValue.getClass());
        }
        if (dMax.compareTo(dMin) < 0) {
            throw new Exception("Specified Range [" + dMin + " , " + dMax + ") is invalid");
        }
        ArrayList<Range> toReturn = new ArrayList<Range>();
        if (linear) {
            double distance = Math.abs(dMin - dMax);
            double step = distance / (double)maxClasses;
            if (integerRanges && step < 1.0) {
                step = 1.0;
            }
            Double toInsertMin = StyleUtils.roundDecimal(dMin, integerRanges ? 0 : 2);
            Double toInsertMax = StyleUtils.roundDecimal(toInsertMin + step, integerRanges ? 0 : 2);
            while (dMax.compareTo(toInsertMax) >= 0) {
                if (integerRanges) {
                    toReturn.add(new Range(attributeName, Color.RED, toInsertMin.intValue(), toInsertMax.intValue(), Range.Condition.BETWEEN));
                } else {
                    toReturn.add(new Range(attributeName, Color.RED, toInsertMin, toInsertMax, Range.Condition.BETWEEN));
                }
                toInsertMin = toInsertMax;
                toInsertMax = StyleUtils.roundDecimal(toInsertMin + step, integerRanges ? 0 : 2);
            }
            if (!dMax.equals(toInsertMin)) {
                if (integerRanges) {
                    toReturn.add(new Range(attributeName, Color.RED, toInsertMin.intValue(), dMax.intValue(), Range.Condition.BETWEEN));
                } else {
                    toReturn.add(new Range(attributeName, Color.RED, toInsertMin, dMax, Range.Condition.BETWEEN));
                }
            }
        } else {
            Double[] logSub = StyleUtils.logSubdivision(dMin, dMax, maxClasses);
            int i = 0;
            while (i < logSub.length) {
                Double upperBound;
                Double d = upperBound = i == logSub.length - 1 ? dMax : logSub[i + 1];
                upperBound = dMax.compareTo(upperBound) <= 0 ? Double.valueOf(StyleUtils.roundDecimal(dMax, integerRanges ? 0 : 2)) : Double.valueOf(StyleUtils.roundDecimal(upperBound, integerRanges ? 0 : 2));
                Double lowerBound = StyleUtils.roundDecimal(logSub[i], integerRanges ? 0 : 2);
                if (integerRanges) {
                    toReturn.add(new Range(attributeName, Color.RED, lowerBound.intValue(), upperBound.intValue(), Range.Condition.BETWEEN));
                } else {
                    toReturn.add(new Range(attributeName, Color.RED, lowerBound, upperBound, Range.Condition.BETWEEN));
                }
                ++i;
            }
        }
        ((Range)toReturn.get(toReturn.size() - 1)).setCondition(Range.Condition.GREATER_THEN_MIN);
        return toReturn;
    }

    private static ArrayList<Color> gradientColors(int nColors, Color c1, Color c2) {
        ArrayList<Color> colors = new ArrayList<Color>();
        int i = 0;
        while (i < nColors) {
            float ratio = (float)i / (float)nColors;
            int red = (int)((float)c2.getRed() * ratio + (float)c1.getRed() * (1.0f - ratio));
            int green = (int)((float)c2.getGreen() * ratio + (float)c1.getGreen() * (1.0f - ratio));
            int blue = (int)((float)c2.getBlue() * ratio + (float)c1.getBlue() * (1.0f - ratio));
            colors.add(new Color(red, green, blue));
            ++i;
        }
        return colors;
    }

    private static double roundDecimal(double number, int decimalposition) {
        double n = (double)Math.round(number * Math.pow(10.0, decimalposition)) / Math.pow(10.0, decimalposition);
        return n;
    }

    private static Double[] logSubdivision(double start, double end, int numberOfParts) {
        if (end <= start) {
            return null;
        }
        double logStart = Math.log(start);
        double logEnd = Math.log(end);
        double difference = logEnd - logStart;
        double step = 0.0;
        if (numberOfParts > 0) {
            step = difference / (double)numberOfParts;
        }
        Double[] linearpoints = new Double[numberOfParts + 1];
        int i = 0;
        while (i < numberOfParts + 1) {
            linearpoints[i] = Math.exp(logStart + (double)i * step);
            if (linearpoints[i] < 0.011) {
                linearpoints[i] = 0.0;
            }
            ++i;
        }
        return linearpoints;
    }

    public static ArrayList<Color> scatterColor(int nColors) {
        ArrayList<Color> colors = new ArrayList<Color>();
        float saturation = 1.0f;
        float brightness = 1.0f;
        int i = 0;
        while (i < nColors) {
            float ratio = (float)i * 1.5f / (float)nColors;
            if (i % 10 == 0) {
                brightness = (float)Math.max(0.1, (double)brightness - 0.1);
            }
            int rgb = Color.HSBtoRGB(ratio, brightness, saturation);
            Color color = new Color(rgb);
            colors.add(color);
            ++i;
        }
        return colors;
    }
}

