/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis.meta;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.gcube.spatial.data.geonetwork.iso.Protocol;
import org.geotoolkit.metadata.iso.DefaultMetadata;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.citation.DefaultCitationDate;
import org.geotoolkit.metadata.iso.citation.DefaultOnlineResource;
import org.geotoolkit.metadata.iso.distribution.DefaultDigitalTransferOptions;
import org.geotoolkit.metadata.iso.distribution.DefaultDistribution;
import org.geotoolkit.metadata.iso.distribution.DefaultFormat;
import org.geotoolkit.metadata.iso.identification.DefaultBrowseGraphic;
import org.geotoolkit.metadata.iso.identification.DefaultDataIdentification;
import org.geotoolkit.util.DefaultInternationalString;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.util.InternationalString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataEnricher {
    static final Logger logger = LoggerFactory.getLogger(MetadataEnricher.class);
    private Metadata toEnrich;
    private DefaultMetadata enriched;
    private ArrayList<String> messages = new ArrayList();
    private String uuid;
    private DefaultDataIdentification ident = null;

    public MetadataEnricher(Metadata toEnrich, boolean generateUUID) {
        this.toEnrich = toEnrich;
        this.enriched = MetadataEnricher.castMeta(toEnrich);
        if (generateUUID) {
            this.uuid = UUID.randomUUID().toString();
            this.enriched.setFileIdentifier(this.uuid);
        } else {
            this.uuid = this.enriched.getFileIdentifier();
        }
        if (this.enriched.getIdentificationInfo().isEmpty()) {
            this.ident = new DefaultDataIdentification();
            this.enriched.getIdentificationInfo().add(this.ident);
        } else {
            this.ident = new DefaultDataIdentification((DataIdentification)this.enriched.getIdentificationInfo().iterator().next());
        }
    }

    public String getMetadataIdentifier() {
        return this.uuid;
    }

    public void addPreview(String previewURL) {
        try {
            this.ident.getGraphicOverviews().add(new DefaultBrowseGraphic(new URI(previewURL)));
        }
        catch (URISyntaxException e) {
            String msg = "Unable to set preview, passed URI is " + previewURL + ", cause : " + e.getMessage();
            logger.warn(msg);
            this.messages.add(msg);
        }
    }

    public void setdistributionURIs(List<String> uris, String layerName) {
        DefaultDistribution distribution = new DefaultDistribution();
        DefaultDigitalTransferOptions transferOptions = new DefaultDigitalTransferOptions();
        for (String uriString : uris) {
            try {
                URI uri = new URI(uriString);
                DefaultOnlineResource resource = new DefaultOnlineResource(uri);
                Protocol protocol = Protocol.getByURI((String)uriString);
                resource.setName(protocol.getName() + " link to resource");
                resource.setProtocol(protocol.getDeclaration());
                resource.setDescription((InternationalString)new DefaultInternationalString("Transfer endpoint compliant to " + protocol.getName() + " protocol."));
                transferOptions.getOnLines().add(resource);
            }
            catch (URISyntaxException e) {
                String msg = "Unable to set transfer option, passed URI is " + uriString + ", cause : " + e.getMessage();
                logger.warn(msg);
                this.messages.add(msg);
            }
        }
        DefaultFormat format1 = new DefaultFormat();
        format1.setName((InternationalString)new DefaultInternationalString(Protocol.WMS.getName()));
        format1.setVersion((InternationalString)new DefaultInternationalString(Protocol.WMS.getVersion()));
        DefaultFormat format2 = new DefaultFormat();
        format2.setName((InternationalString)new DefaultInternationalString(Protocol.WFS.getName()));
        format2.setVersion((InternationalString)new DefaultInternationalString(Protocol.WFS.getVersion()));
        DefaultFormat format3 = new DefaultFormat();
        format3.setName((InternationalString)new DefaultInternationalString(Protocol.WCS.getName()));
        format3.setVersion((InternationalString)new DefaultInternationalString(Protocol.WCS.getVersion()));
        DefaultFormat format4 = new DefaultFormat();
        format4.setName((InternationalString)new DefaultInternationalString(Protocol.HTTP.getName()));
        format4.setVersion((InternationalString)new DefaultInternationalString(Protocol.HTTP.getVersion()));
        distribution.setDistributionFormats(new ArrayList<DefaultFormat>(Arrays.asList(format1, format2, format3, format4)));
        distribution.getTransferOptions().add(transferOptions);
        this.enriched.setDistributionInfo((Distribution)distribution);
    }

    public void addDate(Date toAdd, DateType type) {
        DefaultCitationDate publishDate = new DefaultCitationDate(toAdd, type);
        if (this.ident.getCitation() == null) {
            DefaultCitation citation = new DefaultCitation();
            citation.getDates().add(publishDate);
        } else {
            this.ident.getCitation().getDates().add(publishDate);
        }
    }

    public DefaultMetadata getEnriched() {
        return this.enriched;
    }

    public Metadata getToEnrich() {
        return this.toEnrich;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    private static final DefaultMetadata castMeta(Metadata meta) {
        if (meta.getClass().isAssignableFrom(DefaultMetadata.class)) {
            return (DefaultMetadata)meta;
        }
        return new DefaultMetadata(meta);
    }
}

