/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis.is.cache;

import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.gis.Configuration;
import org.gcube.spatial.data.gis.ResearchMethod;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeoServerCache<T extends AbstractGeoServerDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(GeoServerCache.class);
    private static final ResearchMethod DEFAULT_RESEARCH_METHOD = ResearchMethod.MOSTUNLOAD;

    protected GeoServerCache() {
    }

    public SortedSet<T> getDescriptorSet(Boolean forceUpdate) {
        return this.getTheCache(forceUpdate);
    }

    public T getDefaultDescriptor() {
        return this.getDefaultDescriptor(false);
    }

    public T getDefaultDescriptor(Boolean forceUpdate) {
        return this.getDescriptor(forceUpdate, this.getDefaultMethod());
    }

    public T getDescriptor(Boolean forceUpdate, ResearchMethod method) {
        SortedSet<T> cache = this.getTheCache(forceUpdate);
        log.debug("Access to {} instance in {} ", (Object)method, (Object)ScopeUtils.getCurrentScope());
        switch (method) {
            case MOSTUNLOAD: {
                return (T)((AbstractGeoServerDescriptor)cache.first());
            }
            case RANDOM: {
                int size = cache.size();
                int randomIndex = ThreadLocalRandom.current().nextInt(0, size);
                log.debug("Accessing {} out of {} descriptors ", (Object)randomIndex, (Object)size);
                return (T)((AbstractGeoServerDescriptor)cache.toArray()[randomIndex]);
            }
        }
        throw new RuntimeException("Unrecognized method " + (Object)((Object)method));
    }

    protected ResearchMethod getDefaultMethod() {
        try {
            return ResearchMethod.valueOf(Configuration.get().getProperty("is.accessPolicy"));
        }
        catch (Throwable t) {
            log.warn("Unable to read research method. Using default {}. Cause : ", (Object)DEFAULT_RESEARCH_METHOD, (Object)t);
            return DEFAULT_RESEARCH_METHOD;
        }
    }

    protected abstract SortedSet<T> getTheCache(Boolean var1);
}

