package org.gcube.spatial.data.sdi.model.metadata;

import java.util.HashMap;
import java.util.HashSet;

public class TemplateInvocationBuilder {

	// Constants
	public static final class THREDDS_ONLINE{
		public static final String ID="THREDDS_ONLINE_RESOURCES";
		public static final String HOSTNAME="hostname";
		public static final String FILENAME="filename";
		public static final String CATALOG="catalog";
	}
	
	
	
	
	private HashSet<TemplateInvocation> invocations=new HashSet<TemplateInvocation>();
	
	
	public TemplateInvocationBuilder threddsOnlineResources(String hostname, String filename, String catalog){
		TemplateInvocation toAdd=new TemplateInvocation();
		toAdd.setToInvokeTemplateID(THREDDS_ONLINE.ID);
		HashMap<String,String> parameters=new HashMap<String,String>();
		parameters.put(THREDDS_ONLINE.HOSTNAME, hostname);
		parameters.put(THREDDS_ONLINE.FILENAME, filename);
		parameters.put(THREDDS_ONLINE.CATALOG, catalog);
		toAdd.setTemplateParameters(parameters);
		invocations.add(toAdd);
		return this;
	}
	
	public HashSet<TemplateInvocation> get(){
		return invocations;
	}
}

