/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.model.services;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.gcube.spatial.data.sdi.model.services.WorkspaceDefinition;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class GeoServerDefinition
extends ServiceDefinition {
    @XmlElement
    private ArrayList<WorkspaceDefinition> workspaces;

    @Override
    public ServiceDefinition.Type getType() {
        return ServiceDefinition.Type.GEOSERVER;
    }

    public void addWorkspace(WorkspaceDefinition def) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        this.workspaces.add(def);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        if (this.workspaces != null && !this.workspaces.isEmpty()) {
            for (WorkspaceDefinition workspace : this.workspaces) {
                result = 31 * result + workspace.hashCode();
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoServerDefinition other = (GeoServerDefinition)obj;
        if (this.workspaces == null || this.workspaces.isEmpty()) {
            if (other.workspaces != null && !other.workspaces.isEmpty()) {
                return false;
            }
        } else {
            if (this.workspaces.size() != other.workspaces.size()) {
                return false;
            }
            if (!other.workspaces.containsAll(this.workspaces)) {
                return false;
            }
        }
        return true;
    }

    public ArrayList<WorkspaceDefinition> getWorkspaces() {
        return this.workspaces;
    }

    public void setWorkspaces(ArrayList<WorkspaceDefinition> workspaces) {
        this.workspaces = workspaces;
    }

    public GeoServerDefinition() {
    }

    @ConstructorProperties(value={"workspaces"})
    public GeoServerDefinition(ArrayList<WorkspaceDefinition> workspaces) {
        this.workspaces = workspaces;
    }

    @Override
    public String toString() {
        return "GeoServerDefinition(workspaces=" + this.getWorkspaces() + ")";
    }
}

