/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.deploytest.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBECollectionQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEMCollectionQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEServiceQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.resources.GCUBECollection;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBEMCollection;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.runninginstance.Endpoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.deploytest.client.Deploy;
import org.gcube.deploytest.client.ServiceInfo;

public class QueryInformationSystem {
    ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
    GCUBEScope scope = null;

    public QueryInformationSystem() throws Exception {
        this.scope = GCUBEScope.getScope((String)Deploy.SCOPE);
    }

    public QueryInformationSystem(String scope1) throws Exception {
        this.scope = GCUBEScope.getScope((String)scope1);
    }

    public GCUBEService getServiceProfile(ServiceInfo info) throws ISClient.ISMalformedQueryException, ISClient.ISUnsupportedQueryException, ISException, InstantiationException, IllegalAccessException {
        GCUBEServiceQuery query = null;
        query = (GCUBEServiceQuery)this.client.getQuery(GCUBEServiceQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Class", info.get_serviceClass()), new AtomicCondition("/Profile/Name", info.get_serviceName())});
        Iterator iterator = this.client.execute((ISQuery)query, this.scope).iterator();
        if (iterator.hasNext()) {
            GCUBEService profile = (GCUBEService)iterator.next();
            return profile;
        }
        return null;
    }

    public GCUBECollection getColProfile(String id) throws Exception {
        GCUBECollectionQuery query = null;
        query = (GCUBECollectionQuery)this.client.getQuery(GCUBECollectionQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID", id)});
        Iterator iterator = this.client.execute((ISQuery)query, this.scope).iterator();
        if (iterator.hasNext()) {
            GCUBECollection profile = (GCUBECollection)iterator.next();
            return profile;
        }
        return null;
    }

    public GCUBEMCollection getMColProfile(String id) throws Exception {
        GCUBEMCollectionQuery query = null;
        query = (GCUBEMCollectionQuery)this.client.getQuery(GCUBEMCollectionQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID", id)});
        Iterator iterator = this.client.execute((ISQuery)query, this.scope).iterator();
        if (iterator.hasNext()) {
            GCUBEMCollection profile = (GCUBEMCollection)iterator.next();
            return profile;
        }
        return null;
    }

    public List<GCUBEService> getAllServiceProfile() throws ISClient.ISMalformedQueryException, ISClient.ISUnsupportedQueryException, ISException, InstantiationException, IllegalAccessException {
        GCUBEServiceQuery query = null;
        query = (GCUBEServiceQuery)this.client.getQuery(GCUBEServiceQuery.class);
        return this.client.execute((ISQuery)query, this.scope);
    }

    public List<GCUBEHostingNode> getAllGHNs() throws ISClient.ISMalformedQueryException, ISClient.ISUnsupportedQueryException, ISException, InstantiationException, IllegalAccessException {
        GCUBEGHNQuery query = null;
        query = (GCUBEGHNQuery)this.client.getQuery(GCUBEGHNQuery.class);
        return this.client.execute((ISQuery)query, this.scope);
    }

    public List<GCUBEHostingNode> getGHNWithName(String name) throws ISClient.ISMalformedQueryException, ISClient.ISUnsupportedQueryException, ISException, InstantiationException, IllegalAccessException {
        GCUBEGHNQuery query = null;
        query = (GCUBEGHNQuery)this.client.getQuery(GCUBEGHNQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/GHNDescription/Name", name)});
        return this.client.execute((ISQuery)query, this.scope);
    }

    public List<GCUBEHostingNode> getGHNs() throws ISClient.ISMalformedQueryException, ISClient.ISUnsupportedQueryException, ISException {
        GCUBEGHNQuery query = null;
        try {
            query = (GCUBEGHNQuery)this.client.getQuery(GCUBEGHNQuery.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.client.execute((ISQuery)query, this.scope);
    }

    public String getGHNId(String description) {
        GCUBEGHNQuery query = null;
        String id = null;
        try {
            query = (GCUBEGHNQuery)this.client.getQuery(GCUBEGHNQuery.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/GHNDescription/Name", description)});
        try {
            id = ((GCUBEHostingNode)this.client.execute((ISQuery)query, this.scope).get(0)).getID();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public EndpointReferenceType getVREModelerEndpoint() {
        GCUBERIQuery riquery = null;
        try {
            riquery = (GCUBERIQuery)this.client.getQuery(GCUBERIQuery.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        riquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", "VREModeler")});
        List results = null;
        try {
            results = this.client.execute((ISQuery)riquery, this.scope);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((GCUBERunningInstance)results.get(0)).getAccessPoint().getEndpoint("gcube/vremanagement/vremodeler/ModelerFactoryService");
    }

    public EndpointReferenceType getVREManagerEndpoint() {
        GCUBERIQuery riquery = null;
        try {
            riquery = (GCUBERIQuery)this.client.getQuery(GCUBERIQuery.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        riquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", "VREManager")});
        List results = null;
        try {
            results = this.client.execute((ISQuery)riquery, this.scope);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((GCUBERunningInstance)results.get(0)).getAccessPoint().getEndpoint("gcube/vremanagement/VREManager");
    }

    public EndpointReferenceType getResourceManagerEndpoint() {
        GCUBERIQuery riquery = null;
        try {
            riquery = (GCUBERIQuery)this.client.getQuery(GCUBERIQuery.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        riquery.setExpression("declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry'; for $outer in collection(\"/db/Profiles/RunningInstance\")//Document/Data/is:Profile/Resource  let $scope:= $outer/Scopes/Scope[string() eq '" + this.scope.toString() + "'] " + " where count($scope)>0 " + " and $outer/Profile/ServiceName/string() eq 'ResourceManager' " + " return $outer");
        List results = null;
        try {
            results = this.client.execute((ISQuery)riquery, this.scope);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((GCUBERunningInstance)results.get(0)).getAccessPoint().getEndpoint("gcube/vremanagement/ResourceManager");
    }

    public EndpointReferenceType getRegistryEndpoint() {
        GCUBERIQuery riquery = null;
        try {
            riquery = (GCUBERIQuery)this.client.getQuery(GCUBERIQuery.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        riquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", "IS-Registry")});
        List results = null;
        try {
            results = this.client.execute((ISQuery)riquery, this.scope);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((GCUBERunningInstance)results.get(0)).getAccessPoint().getEndpoint("gcube/informationsystem/registry/RegistryFactory");
    }

    public EndpointReferenceType getEndpoint(String serviceName, String serviceClass, String ghnId) {
        EndpointReferenceType epr = null;
        GCUBERIQuery riQuery = null;
        try {
            riQuery = (GCUBERIQuery)this.client.getQuery(GCUBERIQuery.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        riQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceClass", serviceClass), new AtomicCondition("//ServiceName", serviceName), new AtomicCondition("//GHN/@UniqueID", ghnId)});
        try {
            for (GCUBERunningInstance instance : this.client.execute((ISQuery)riQuery, this.scope)) {
                for (Endpoint endpoint : instance.getAccessPoint().getRunningInstanceInterfaces().getEndpoint()) {
                    epr = new EndpointReferenceType();
                    epr.setAddress(new AttributedURI((URI)new Address(endpoint.getValue())));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return epr;
    }

    public String getRunningInstanceID(String serviceName, String serviceClass, String ghnId) {
        String id = null;
        GCUBERIQuery riQuery = null;
        try {
            riQuery = (GCUBERIQuery)this.client.getQuery(GCUBERIQuery.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        riQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceClass", serviceClass), new AtomicCondition("//ServiceName", serviceName), new AtomicCondition("//GHN/@UniqueID", ghnId)});
        try {
            for (GCUBERunningInstance instance : this.client.execute((ISQuery)riQuery, this.scope)) {
                id = instance.getID();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public List<XMLResult> performGenericQuery(String xquery) throws ISClient.ISMalformedQueryException, ISClient.ISUnsupportedQueryException, ISException {
        GCUBEGenericQuery query = null;
        try {
            query = (GCUBEGenericQuery)this.client.getQuery(GCUBEGenericQuery.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        query.setExpression(xquery);
        return this.client.execute((ISQuery)query, this.scope);
    }

    public String getGenericResourceBySecondaryType(String secondaryType) throws Exception {
        GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)this.client.getQuery(GCUBEGenericResourceQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//SecondaryType", secondaryType)});
        List array = this.client.execute((ISQuery)query, this.scope);
        if (array != null && !array.isEmpty()) {
            return ((GCUBEGenericResource)array.get(0)).getID();
        }
        return "";
    }

    public EndpointReferenceType getWSResourceEpr(String serviceClass, String serviceName, String indexId) throws Exception {
        WSResourceQuery query = (WSResourceQuery)this.client.getQuery(WSResourceQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", serviceName)});
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceClass", serviceClass)});
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//IndexID", indexId)});
        List array = this.client.execute((ISQuery)query, this.scope);
        if (array != null && !array.isEmpty()) {
            return ((RPDocument)array.get(0)).getEndpoint();
        }
        return null;
    }

    public String getGenericResourceByName(String name) throws Exception {
        GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)this.client.getQuery(GCUBEGenericResourceQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Name", name)});
        List array = this.client.execute((ISQuery)query, this.scope);
        if (array != null && !array.isEmpty()) {
            return ((GCUBEGenericResource)array.get(0)).getID();
        }
        return "";
    }

    public ArrayList<String> getMetadataCollectionIds() throws Exception {
        ArrayList<String> mcol = new ArrayList<String>();
        GCUBEMCollectionQuery query = (GCUBEMCollectionQuery)this.client.getQuery(GCUBEMCollectionQuery.class);
        List array = this.client.execute((ISQuery)query, this.scope);
        for (GCUBEMCollection mc : array) {
            mcol.add(mc.getID());
        }
        return mcol;
    }

    public List<GCUBEMCollection> getMetadataCollections() throws Exception {
        GCUBEMCollectionQuery query = (GCUBEMCollectionQuery)this.client.getQuery(GCUBEMCollectionQuery.class);
        return this.client.execute((ISQuery)query, this.scope);
    }

    public List<GCUBECollection> getCollections() throws Exception {
        GCUBECollectionQuery query = (GCUBECollectionQuery)this.client.getQuery(GCUBECollectionQuery.class);
        return this.client.execute((ISQuery)query, this.scope);
    }

    public List<GCUBEGenericResource> getGenericResources() throws Exception {
        GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)this.client.getQuery(GCUBEGenericResourceQuery.class);
        return this.client.execute((ISQuery)query, this.scope);
    }

    public String getGHNName(String ghnID) throws Exception {
        GCUBEGHNQuery query = null;
        query = (GCUBEGHNQuery)this.client.getQuery(GCUBEGHNQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID", ghnID)});
        GCUBEHostingNode profile = (GCUBEHostingNode)this.client.execute((ISQuery)query, this.scope).get(0);
        return profile.getNodeDescription().getName();
    }
}

