/*
 * Decompiled with CFR 0.152.
 */
package it.eng.d4s.sa3.model;

import it.eng.d4s.sa3.model.ModuleBuild;
import it.eng.d4s.sa3.repository.resourcetype.BuildResourceType;
import it.eng.d4s.sa3.repository.subrepository.BuildRepository;
import it.eng.d4s.sa3.util.XMLInitialization;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Build
extends XMLInitialization {
    private static final Logger LOGGER = Logger.getLogger(Build.class);
    protected static DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    protected Map<String, ModuleBuild> moduleBuildsByConfigName;
    protected String moduleName;
    protected String configurationName;
    protected String configurationVersion;
    protected String platform;
    protected Date startTime;
    protected Date endTime;
    protected BuildRepository repo = null;
    protected String buildName = null;
    protected boolean invalid = false;
    protected int nFailedModules = 0;
    protected int nHasFailedDepsModules = 0;
    protected int nModules = 0;

    public Build() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Build(BuildRepository repo, String bcName, String buildName) {
        this.repo = repo;
        this.buildName = buildName;
        this.moduleBuildsByConfigName = new HashMap<String, ModuleBuild>();
        InputStream buildStatusXmlStream = null;
        try {
            buildStatusXmlStream = repo.getBResourceIS(BuildResourceType.B_BUILD_STATUS);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(buildStatusXmlStream);
            this.accept(document);
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Error initializing build " + this + ". Error was: " + e.getMessage()));
            e.printStackTrace();
            this.invalid = true;
        }
        finally {
            if (buildStatusXmlStream != null) {
                try {
                    buildStatusXmlStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public ModuleBuild getModuleBuild(String moduleConfigurationName) {
        return this.moduleBuildsByConfigName.get(moduleConfigurationName);
    }

    public Collection<ModuleBuild> getAllModuleBuilds() {
        return this.moduleBuildsByConfigName.values();
    }

    public int getNFailedModules() {
        return this.nFailedModules;
    }

    public int getNModules() {
        return this.nModules;
    }

    public int getNHasFailedDepsModules() {
        return this.nHasFailedDepsModules;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public String getConfigurationVersion() {
        return this.configurationVersion;
    }

    public BuildRepository getRepo() {
        return this.repo;
    }

    public Map<String, ModuleBuild> getModuleBuildsByConfigName() {
        return this.moduleBuildsByConfigName;
    }

    public void setModuleBuildsByConfigName(Map<String, ModuleBuild> moduleBuildsByConfigName) {
        this.moduleBuildsByConfigName = moduleBuildsByConfigName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setConfigurationVersion(String configurationVersion) {
        this.configurationVersion = configurationVersion;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setRepo(BuildRepository repo) {
        this.repo = repo;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public void setNFailedModules(int failedModules) {
        this.nFailedModules = failedModules;
    }

    public void setNHasFailedDepsModules(int hasFailedDepsModules) {
        this.nHasFailedDepsModules = hasFailedDepsModules;
    }

    public void setNModules(int modules) {
        this.nModules = modules;
    }

    @Override
    protected void accept(Node node) throws Exception {
        String nodeName = node.getNodeName();
        if (nodeName.equals("module")) {
            ModuleBuild mb = null;
            try {
                mb = new ModuleBuild(node);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (mb != null) {
                this.trackNewModuleReport(mb);
            }
        } else {
            if (nodeName.equals("project")) {
                String date;
                try {
                    date = this.getAttribute(node, "endtime");
                    this.endTime = date != null ? df.parse(date) : new Date();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                try {
                    date = this.getAttribute(node, "starttime");
                    this.startTime = date != null ? df.parse(date) : new Date();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                this.moduleName = this.getAttribute(node, "modulename");
                this.configurationVersion = this.getAttribute(node, "moduleversion");
                this.configurationName = this.getAttribute(node, "moduleconfig");
                this.platform = this.getAttribute(node, "platform");
            }
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.accept(children.item(i));
            }
        }
    }

    protected void trackNewModuleReport(ModuleBuild bsmr) {
        this.moduleBuildsByConfigName.put(bsmr.getConfigurationName(), bsmr);
        bsmr.setBuild(this);
        ++this.nModules;
        if (!bsmr.isBuilt() || bsmr.hasFailedDeps()) {
            ++this.nFailedModules;
        }
        if (bsmr.hasFailedDeps()) {
            ++this.nHasFailedDepsModules;
        }
    }

    public String toString() {
        return "[BUILD:" + this.repo.getHomeDir() + "]";
    }
}

