/*
 * Decompiled with CFR 0.152.
 */
package it.eng.d4s.sa3.repository.subrepository;

import it.eng.d4s.sa3.model.ModuleBuild;
import it.eng.d4s.sa3.repository.RepositoryException;
import it.eng.d4s.sa3.repository.SA3Repository;
import it.eng.d4s.sa3.repository.SubRepository;
import it.eng.d4s.sa3.repository.resourcetype.BuildResourceType;
import it.eng.d4s.sa3.util.GZipReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class BuildRepository
extends SubRepository {
    private static final Logger LOGGER = Logger.getLogger(BuildRepository.class);
    public static final String DIST_DIR = "dist";
    public static final String REPORTS_DIR = "reports";
    String buildName = null;
    boolean isArchived = false;

    public BuildRepository(SA3Repository sa3repo, String buildName, String homeDir, boolean isArchived) {
        super(sa3repo, homeDir);
        this.buildName = buildName;
        this.isArchived = isArchived;
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public String getBResorucePath(BuildResourceType rt) {
        switch (rt) {
            case B_BUILD_STATUS: {
                return "build-status.xml";
            }
            case B_PACKAGES_REPORT: {
                return "reports/d4s-packages/packages-report.xml";
            }
            case B_BUILDER_OUTPUT: {
                return "builder_output";
            }
            case B_BUILDER_STDERR: {
                return "builder_stderr";
            }
            case B_CO_SIZES_REPORT: {
                return "reports/d4s-co-sizes/co-sizes.xml";
            }
            case B_CHECKSTYLE_REPORT: {
                return "reports/d4s-checkstyle/checkstyleReport.xml";
            }
            case B_CHECKSTYLE_DATA_DIR: {
                return "reports/d4s-checkstyle/";
            }
            case B_DEPLOYMENT_REPORT: {
                return "dt.xml";
            }
            case B_SA_CERTIFICATION_REPORT: {
                return "certification.xml";
            }
            case B_FINDBUGS_DATA_DIR: {
                return "reports/findbugs/";
            }
            case B_DISTRIBUTION_REPORT: {
                return "distribution.xml";
            }
            case B_NEW_DISTRIBUTION_LOG_REPORT: {
                return "reports/distribution_log.xml";
            }
            case B_NEW_DISTRIBUTION_EXCEPTIONS: {
                return "reports/distribution_exceptions.txt";
            }
        }
        return null;
    }

    public String getMResorucePath(BuildResourceType rt, ModuleBuild mb) {
        switch (rt) {
            case M_CHECKOUT_LOG: {
                return "reports/" + mb.getCheckoutLogFile();
            }
            case M_BUILD_LOG: {
                return "reports/" + mb.getBuildLogFile();
            }
            case M_DEPLOYMENT_REPORT: {
                return "[not implemented here!. See source code for datalis]";
            }
            case M_FINDBUGS_REPORT: {
                return this.getBResorucePath(BuildResourceType.B_FINDBUGS_DATA_DIR) + "/" + mb.getModuleName() + "-" + mb.getConfigurationName() + "/" + "index-bugs.html";
            }
            case M_TGZ_ARTEFACT: {
                return "dist/" + mb.getProjectName() + "/" + mb.getModuleName() + "/" + mb.getVersion().getRawRepresentation() + "/" + mb.getBuild().getPlatform() + "/" + mb.getArtefactFilename();
            }
            case M_CHECKSTYLE_HTML_REPORT: {
                return this.getBResorucePath(BuildResourceType.B_CHECKSTYLE_DATA_DIR) + "/" + "CHECKSTYLE-REPORT-" + mb.getModuleName() + ".html";
            }
            case M_CHECKSTYLE_XML_REPORT: {
                return this.getBResorucePath(BuildResourceType.B_CHECKSTYLE_DATA_DIR) + "/" + "CHECKSTYLE-REPORT-" + mb.getModuleName() + ".xml";
            }
            case M_HTML_REPORT: {
                return "reports/reportModuleDetail-" + mb.getModuleName() + ".html";
            }
        }
        return null;
    }

    public String getBResourceAbsolutePath(BuildResourceType rt) {
        return super.getAbsoluteResourcePath(this.getBResorucePath(rt));
    }

    public String getMResourceAbsolutePath(BuildResourceType rt, ModuleBuild mb) {
        return super.getAbsoluteResourcePath(this.getMResorucePath(rt, mb));
    }

    public InputStream getBResourceIS(BuildResourceType rt) throws RepositoryException {
        return this.getResourceIS(this.getBResorucePath(rt));
    }

    public InputStream getMResourceIS(BuildResourceType rt, ModuleBuild mb) throws RepositoryException {
        return this.getResourceIS(this.getMResorucePath(rt, mb));
    }

    public boolean existsBResource(BuildResourceType rt) {
        return this.resourceExists(this.getBResorucePath(rt));
    }

    public boolean existsMResource(BuildResourceType rt, ModuleBuild mb) {
        return this.resourceExists(this.getMResorucePath(rt, mb));
    }

    public InputStream getResourceIS(String resourcePath) throws RepositoryException {
        if (this.isArchived) {
            String file = this.homeDir + ".tar.gz";
            String entry = this.buildName + "/" + resourcePath;
            try {
                byte[] res = GZipReader.getInnerEntry(file, entry);
                return new ByteArrayInputStream(res);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }
        return super.getResourceIS(resourcePath);
    }

    public boolean resourceExists(String resourcePath) {
        if (this.isArchived) {
            String file = this.homeDir + ".tar.gz";
            String entry = this.buildName + "/" + resourcePath;
            try {
                return GZipReader.entryExists(file, entry);
            }
            catch (IOException e) {
                return false;
            }
        }
        return super.resourceExists(resourcePath);
    }
}

