/*
 * Decompiled with CFR 0.152.
 */
package it.eng.d4s.sa3.util;

import java.util.StringTokenizer;

public class Version {
    private static final String DEFAULT_PARSING_SEPARATORS = "._-";
    private String major = "0";
    private String minor = "0";
    private String revision = "0";
    private String age = "0";
    private String rawRepresentation = "0.0.0.0";

    public Version(String rawRepresentation) {
        this(rawRepresentation, DEFAULT_PARSING_SEPARATORS);
    }

    public Version(String version, String separators) {
        this.rawRepresentation = version;
        this.parseRawRepresentation(separators);
    }

    public Version(String major, String minor, String revision, String age) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.age = age;
        this.rawRepresentation = this.getNormalizedRepresentation();
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getAge() {
        return this.age;
    }

    public String getNormalizedRepresentation() {
        return this.toString();
    }

    public String getRawRepresentation() {
        return this.rawRepresentation;
    }

    public boolean equals(Object obj) {
        Version v = (Version)obj;
        return this.major.equals(v.major) && this.minor.equals(v.minor) && this.revision.equals(v.revision) && this.age.equals(v.age);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.revision + "-" + this.age;
    }

    private void parseRawRepresentation(String separators) {
        if (this.rawRepresentation == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.rawRepresentation, separators);
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        this.major = Version.normalizeToken(tokenizer.nextToken());
        if (tokenizer.hasMoreTokens()) {
            this.minor = Version.normalizeToken(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            this.revision = Version.normalizeToken(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            this.age = Version.normalizeToken(tokenizer.nextToken());
        }
    }

    private static String normalizeToken(String field) {
        String res = field.toLowerCase();
        try {
            res = Integer.valueOf(res).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public static void main(String[] args) {
        Version v = new Version("ciao");
        Version v2 = new Version("1.0.1.0", ".");
        System.out.println(v);
        System.out.println(v2);
        System.out.println(v.equals(v2));
    }
}

