/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.resourcemanager.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.gcube.tools.resourcemanager.util.ServiceDeployment;

public class ParsePropertyFile {
    private ArrayList<ServiceDeployment> services = new ArrayList();
    Properties resources = new Properties();

    public ParsePropertyFile(String string) throws IOException {
        try {
            this.resources.load(new FileInputStream(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }

    public ArrayList<ServiceDeployment> getServices() throws Exception {
        Integer n = null;
        if (this.resources.getProperty("numOfServicesToAdd") != null) {
            n = new Integer(this.resources.getProperty("numOfServicesToAdd"));
        } else if (this.resources.getProperty("numOfServicesToRemove") != null) {
            n = new Integer(this.resources.getProperty("numOfServicesToRemove"));
        } else if (this.resources.getProperty("numOfServicesToUpgrade") != null) {
            n = new Integer(this.resources.getProperty("numOfServicesToUpgrade"));
        } else {
            throw new Exception("numOfServicesToAdd/Remove/upgrade missing on properties file");
        }
        for (int i = 1; i < n + 1; ++i) {
            ServiceDeployment serviceDeployment = new ServiceDeployment();
            serviceDeployment.setServiceClass(this.resources.getProperty("service." + i + ".class"));
            serviceDeployment.setServiceName(this.resources.getProperty("service." + i + ".name"));
            serviceDeployment.setVersion(this.resources.getProperty("service." + i + ".version"));
            if (this.resources.getProperty("service." + i + ".GHN") != null) {
                serviceDeployment.setGHN(this.resources.getProperty("service." + i + ".GHN"));
            }
            this.services.add(serviceDeployment);
        }
        return this.services;
    }
}

