package org.gcube.vremanagement.contextmanager;


import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.util.List;

import javax.xml.bind.JAXBException;

import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.smartgears.ApplicationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextAppManager implements ApplicationManager {

	private static Logger logger = LoggerFactory.getLogger(ContextAppManager.class);
	
	
	MultiKeysMap<String, String,  ScopeDescriptor> scopeDescriptorMap = new MultiKeysMap<String, String,ScopeDescriptor>(); 
	
	@Override
	public void onInit() {
		String currentContext = ScopeProvider.instance.get();
		logger.info("resource initialization started in {} ",currentContext);
		
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text eq 'VRE' or $resource/Profile/SecondaryType/text eq 'VO'");
		
		DiscoveryClient<GenericResource> client = clientFor(GenericResource.class);
		List<GenericResource> resources = client.submit(query);
		for (GenericResource resource : resources) {
			try {
				String body = resource.profile().bodyAsString();
				ScopeDescriptor scopeDescr = ResourceBinder.get().bind(body);
				scopeDescriptorMap.put(scopeDescr.context, resource.id(), scopeDescr);
			} catch (JAXBException e) {
				logger.error("cannot unmarshal resource",e);
			}
		}
	
	}

	@Override
	public void onShutdown() {
	}

	public MultiKeysMap<String, String, ScopeDescriptor> getScopeDescriptorMap() {
		return scopeDescriptorMap;
	}

	
	
}
