/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.contextmanager.model.operators.context;

import org.gcube.vremanagement.contextmanager.model.exceptions.InvalidParameterException;
import org.gcube.vremanagement.contextmanager.model.exceptions.OperationException;
import org.gcube.vremanagement.contextmanager.model.operators.OperatorParameters;
import org.gcube.vremanagement.contextmanager.model.operators.context.ContextOperator;
import org.gcube.vremanagement.contextmanager.model.report.OperationResult;
import org.gcube.vremanagement.contextmanager.model.report.ReportEntry;
import org.gcube.vremanagement.contextmanager.model.types.Context;

public abstract class CustomContextOperator<T, P extends OperatorParameters>
implements ContextOperator {
    protected abstract P checkAndTrasformParameters(Context var1, OperatorParameters var2) throws InvalidParameterException;

    protected abstract T execute(Context var1, P var2) throws OperationException;

    public abstract T undo(Context var1, OperatorParameters var2);

    public ReportEntry<T> run(Context context, P params) {
        P operationParams = null;
        try {
            operationParams = this.checkAndTrasformParameters(context, (OperatorParameters)params);
        }
        catch (InvalidParameterException e) {
            return new ReportEntry<Object>(this.getOperationId(), this.getDescription(), OperationResult.failure("parameters error: " + e.getMessage()), null);
        }
        catch (Throwable e) {
            return new ReportEntry<Object>(this.getOperationId(), this.getDescription(), OperationResult.failure("unexpected parameters error: " + e.getMessage()), null);
        }
        Object result = null;
        try {
            result = this.execute(context, operationParams);
        }
        catch (OperationException e) {
            return new ReportEntry<Object>(this.getOperationId(), this.getDescription(), OperationResult.failure("operation error: " + e.getMessage()), null);
        }
        catch (Throwable e) {
            return new ReportEntry<Object>(this.getOperationId(), this.getDescription(), OperationResult.failure("unexpected operation error: " + e.getMessage()), null);
        }
        return new ReportEntry<Object>(this.getOperationId(), this.getDescription(), OperationResult.success(), result);
    }
}

