/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.plugin;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.UUID;
import javax.xml.bind.annotation.XmlElement;
import org.gcube.vremanagement.executor.exception.InvalidPluginStateEvolutionException;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.gcube.vremanagement.executor.plugin.RunOn;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class PluginStateEvolution {
    @XmlElement
    protected UUID uuid;
    @XmlElement
    protected int iteration;
    @XmlElement
    protected long timestamp;
    protected PluginDeclaration pluginDeclaration;
    @XmlElement
    protected PluginState pluginState;
    @XmlElement
    protected int percentage;
    @XmlElement
    protected RunOn runOn;

    public PluginStateEvolution() {
    }

    public PluginStateEvolution(UUID uuid, int iteration, long timestamp, PluginDeclaration pluginDeclaration, PluginState pluginState, Integer percentage) throws InvalidPluginStateEvolutionException {
        this.uuid = uuid;
        this.iteration = iteration;
        this.timestamp = timestamp;
        this.pluginDeclaration = pluginDeclaration;
        this.pluginState = pluginState;
        switch (pluginState) {
            case CREATED: {
                this.percentage = 0;
                break;
            }
            default: {
                if (percentage < 0 || percentage > 100) {
                    throw new InvalidPluginStateEvolutionException("Percentage must be beetween 0 and 100");
                }
                this.percentage = percentage;
            }
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getIteration() {
        return this.iteration;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @JsonGetter
    public PluginDeclaration getPluginDeclaration() {
        return this.pluginDeclaration;
    }

    public PluginState getPluginState() {
        return this.pluginState;
    }

    public Integer getPercentage() {
        return this.percentage;
    }

    protected RunOn getRunOn() {
        return this.runOn;
    }

    protected void setRunOn(RunOn runOn) {
        this.runOn = runOn;
    }

    public String toString() {
        return String.format("{uuid:%s,iteration:%d,timestamp:%d,pluginDeclaration:%s,pluginState:%s,percentage:%d}", new Object[]{this.uuid, this.iteration, this.timestamp, this.pluginDeclaration, this.pluginState, this.percentage});
    }
}

