package org.gcube.vremanagement.executor.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

/**
 * Utility class for input/output operations.
 * This class provides static methods for common I/O tasks.
 */
public abstract class IOUtility {

	/**
	 * Reads the entire content of a file and returns it as a string.
	 * @param filePath the path to the file to read
	 * @return the content of the file as a string
	 * @throws IOException if an I/O error occurs
	 */
	public static String readFile(String filePath) throws IOException {
		BufferedReader reader = new BufferedReader(new FileReader(filePath));
		String line = null;
		StringBuilder stringBuilder = new StringBuilder();
		String ls = System.getProperty("line.separator");
	
		while ((line = reader.readLine()) != null) {
			stringBuilder.append(line);
			stringBuilder.append(ls);
		}
		reader.close();
		
		return stringBuilder.toString();
	}
	
}
