/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.configuration.jsonbased;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.gcube.smartgears.ContextProvider;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.api.types.Scheduling;
import org.gcube.vremanagement.executor.configuration.ScheduledTaskConfiguration;
import org.gcube.vremanagement.executor.configuration.jsonbased.JSONLaunchParameter;
import org.gcube.vremanagement.executor.configuration.jsonbased.JSONScheduling;
import org.gcube.vremanagement.executor.exception.SchedulePersistenceException;
import org.gcube.vremanagement.executor.exception.ScopeNotMatchException;
import org.gcube.vremanagement.executor.utils.IOUtility;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileScheduledTaskConfiguration
implements ScheduledTaskConfiguration {
    private static Logger logger = LoggerFactory.getLogger(FileScheduledTaskConfiguration.class);
    protected String configurationFileLocation;
    protected List<LaunchParameter> configuredTasks;
    public static final String CONFIG_TASK_FILENAME = "definedTasks.json";

    public FileScheduledTaskConfiguration() throws Exception {
        this(ContextProvider.get().persistence().location());
    }

    public FileScheduledTaskConfiguration(String location) throws IOException, JSONException {
        this.configurationFileLocation = location;
        this.configuredTasks = new ArrayList();
        this.configuredTasks = this.retriveConfiguredTask();
    }

    protected Scheduling getScheduling(JSONObject jsonObject) throws JSONException, ParseException, ScopeNotMatchException {
        return new JSONScheduling(jsonObject);
    }

    protected static String configurationFileName(String configurationFileLocation) {
        return configurationFileLocation + "/" + "definedTasks.json";
    }

    public List<LaunchParameter> retriveConfiguredTask() throws IOException, JSONException {
        String configuredTasksDefinition = IOUtility.readFile((String)FileScheduledTaskConfiguration.configurationFileName((String)this.configurationFileLocation));
        ArrayList<LaunchParameter> tasks = new ArrayList<LaunchParameter>();
        JSONArray jsonArray = new JSONArray(configuredTasksDefinition);
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                JSONLaunchParameter parameter = new JSONLaunchParameter(jsonObject);
                tasks.add((LaunchParameter)parameter);
                continue;
            }
            catch (Exception e) {
                logger.error("Error launching configurad Task", e.getCause());
            }
        }
        return tasks;
    }

    protected void emptyConfigurationFile(String fileName) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(fileName);
        writer.print("");
        writer.close();
    }

    protected void writeOnConfigurationFile() throws JSONException, IOException, ParseException {
        String fileName = FileScheduledTaskConfiguration.configurationFileName((String)this.configurationFileLocation);
        JSONArray jsonArray = new JSONArray();
        for (LaunchParameter launchParameter : this.configuredTasks) {
            JSONLaunchParameter jsonLaunchParameter = new JSONLaunchParameter(launchParameter);
            jsonArray.put((Object)jsonLaunchParameter.toJSON());
        }
        String jsonArrayString = jsonArray.toString();
        this.emptyConfigurationFile(fileName);
        FileUtils.writeStringToFile((File)new File(fileName), (String)jsonArrayString);
    }

    public synchronized void addScheduledTask(UUID uuid, String consumerID, LaunchParameter parameter) throws SchedulePersistenceException {
        try {
            this.addLaunch(new JSONLaunchParameter(parameter));
        }
        catch (ParseException e) {
            throw new SchedulePersistenceException(e.getCause());
        }
    }

    public synchronized void addLaunch(JSONLaunchParameter parameter) throws SchedulePersistenceException {
        this.configuredTasks.add(parameter);
        try {
            this.writeOnConfigurationFile();
        }
        catch (IOException | ParseException | JSONException e) {
            throw new SchedulePersistenceException();
        }
    }

    public void releaseLaunch(LaunchParameter parameter) throws SchedulePersistenceException {
        try {
            this.removeLaunch(new JSONLaunchParameter(parameter));
        }
        catch (IOException | ParseException | JSONException e) {
            throw new SchedulePersistenceException(e.getCause());
        }
    }

    protected synchronized void removeLaunch(JSONLaunchParameter parameter) throws ParseException, JSONException, IOException {
        this.configuredTasks.remove(parameter);
        this.writeOnConfigurationFile();
    }

    public List<LaunchParameter> getConfiguredTasks() {
        return this.configuredTasks;
    }

    public void setConfiguredTasks(List<LaunchParameter> configuredTasks) {
        this.configuredTasks = configuredTasks;
    }

    public List<LaunchParameter> getAvailableScheduledTasks() throws SchedulePersistenceException {
        return null;
    }

    public void reserveScheduledTask(UUID uuid, String consumerID) throws SchedulePersistenceException {
    }

    public void removeScheduledTask(UUID uuid) throws SchedulePersistenceException {
    }

    public void releaseScheduledTask(UUID uuid) throws SchedulePersistenceException {
    }

    public LaunchParameter getScheduledTask(UUID uuid) throws SchedulePersistenceException {
        return null;
    }
}

