/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.scheduler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.api.types.Scheduling;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.LaunchException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.exception.SchedulePersistenceException;
import org.gcube.vremanagement.executor.exception.SchedulerNotFoundException;
import org.gcube.vremanagement.executor.exception.SchedulerRemoveException;
import org.gcube.vremanagement.executor.exception.UnableToInterruptTaskException;
import org.gcube.vremanagement.executor.json.ObjectMapperManager;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTask;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTaskPersistence;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTaskPersistenceFactory;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorTask;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorTaskListener;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartExecutorScheduler {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorScheduler.class);
    protected Map<UUID, Scheduler> activeSchedulers = new HashMap();
    private static SmartExecutorScheduler smartExecutorScheduler;

    public static synchronized SmartExecutorScheduler getInstance() {
        if (smartExecutorScheduler == null) {
            smartExecutorScheduler = new SmartExecutorScheduler();
        }
        return smartExecutorScheduler;
    }

    private SmartExecutorScheduler() {
    }

    protected TriggerBuilder<? extends Trigger> createTriggerBuilder(UUID uuid, ScheduleBuilder<? extends Trigger> sb) {
        return TriggerBuilder.newTrigger().withIdentity(uuid.toString()).withSchedule(sb);
    }

    protected TriggerBuilder<? extends Trigger> getTriggerBuilderWithScheduling(UUID uuid, Scheduling scheduling) throws LaunchException {
        int times = scheduling.getSchedulingTimes();
        if (scheduling.getCronExpression() != null) {
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduling.getCronExpression());
            return this.createTriggerBuilder(uuid, (ScheduleBuilder)cronScheduleBuilder);
        }
        if (scheduling.getDelay() != null) {
            SimpleScheduleBuilder simpleScheduleBuilder = times != 0 ? SimpleScheduleBuilder.repeatSecondlyForTotalCount((int)times, (int)scheduling.getDelay()) : SimpleScheduleBuilder.repeatSecondlyForever((int)scheduling.getDelay());
            return this.createTriggerBuilder(uuid, (ScheduleBuilder)simpleScheduleBuilder);
        }
        throw new LaunchException("Invalid Scheduling");
    }

    protected Scheduler reallySchedule(UUID uuid, LaunchParameter parameter) throws LaunchException, SchedulerException {
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        Scheduler scheduler = schedulerFactory.getScheduler();
        JobKey jobKey = new JobKey(uuid.toString());
        JobDetail jobDetail = JobBuilder.newJob(SmartExecutorTask.class).withIdentity(jobKey).build();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("UUID", (Object)uuid);
        jobDataMap.put("LAUNCH_PARAMETER", (Object)parameter);
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(uuid.toString());
        Scheduling scheduling = parameter.getScheduling();
        if (scheduling != null) {
            try {
                logger.info("Going to schedule Taks with UUID with the following {} : {}", new Object[]{uuid, LaunchParameter.class.getSimpleName(), ObjectMapperManager.getObjectMapper().writeValueAsString((Object)parameter)});
            }
            catch (Exception exception) {
                // empty catch block
            }
            triggerBuilder = this.getTriggerBuilderWithScheduling(uuid, scheduling);
            if (scheduling.getFirstStartTime() != null && scheduling.getFirstStartTime() != 0L) {
                Date triggerStartTime = new Date(scheduling.getFirstStartTime());
                triggerBuilder.startAt(triggerStartTime);
            }
            if (scheduling.getEndTime() != null && scheduling.getEndTime() != 0L) {
                Date triggerEndTime = new Date(scheduling.getEndTime());
                triggerBuilder.endAt(triggerEndTime);
            }
            try {
                ScheduledTaskPersistence stc = ScheduledTaskPersistenceFactory.getScheduledTaskPersistence();
                ScheduledTask scheduledTask = new ScheduledTask(uuid, parameter);
                logger.debug("Going to persist Scheduled Task {} : {} ", (Object)scheduledTask);
                stc.addScheduledTask(scheduledTask);
            }
            catch (Exception e) {
                logger.error("Unable to persist Scheduled Task {}", (Object)uuid.toString(), (Object)e.getCause());
            }
        } else {
            try {
                logger.info("Starting Taks with UUID {} immediately with the following {} : {}", new Object[]{uuid, LaunchParameter.class.getSimpleName(), ObjectMapperManager.getObjectMapper().writeValueAsString((Object)parameter)});
            }
            catch (Exception e) {
                // empty catch block
            }
            triggerBuilder.startNow();
        }
        try {
            SmartExecutorTaskListener sejl = new SmartExecutorTaskListener();
            scheduler.getListenerManager().addJobListener((JobListener)sejl);
            scheduler.scheduleJob(jobDetail, triggerBuilder.build());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        return scheduler;
    }

    public synchronized UUID schedule(LaunchParameter parameter, UUID uuid) throws InputsNullException, PluginNotFoundException, LaunchException {
        Map inputs = parameter.getInputs();
        if (inputs == null) {
            throw new InputsNullException();
        }
        PluginManager.getPluginDeclaration((String)parameter.getPluginName());
        if (uuid == null) {
            uuid = UUID.randomUUID();
        }
        try {
            Scheduler scheduler = this.reallySchedule(uuid, parameter);
            this.activeSchedulers.put(uuid, scheduler);
            scheduler.start();
        }
        catch (SchedulerException e) {
            throw new LaunchException((Throwable)e);
        }
        return uuid;
    }

    public Scheduler getScheduler(UUID key) {
        return (Scheduler)this.activeSchedulers.get(key);
    }

    protected void stopLastcurrentExecution(Scheduler scheduler, UUID uuid) throws UnableToInterruptTaskException {
        JobKey jobKey = new JobKey(uuid.toString());
        try {
            logger.debug("Going to stop current SmartExecutor Task {} execution if any", (Object)uuid);
            if (!scheduler.checkExists(jobKey)) {
                logger.debug("No SmartExecutor Task {} was found. That's all folk.", (Object)uuid);
                throw new SchedulerNotFoundException("Scheduler Not Found");
            }
            boolean interrupted = scheduler.interrupt(jobKey);
            if (interrupted) {
                logger.debug("SmartExecutor Task {} interrupted successfully.", (Object)uuid);
            } else {
                List list = this.getCurrentlyExecutingJobs(scheduler);
                if (list != null && list.size() > 0) {
                    logger.debug("SmartExecutor Task {} was not interrupted.", (Object)uuid);
                    throw new UnableToInterruptTaskException(uuid);
                }
            }
        }
        catch (UnableToInterruptTaskException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnableToInterruptTaskException(uuid, (Throwable)e);
        }
    }

    protected void deleteScheduler(Scheduler scheduler, UUID uuid) throws SchedulerRemoveException {
        block11: {
            JobKey jobKey = new JobKey(uuid.toString());
            try {
                logger.debug("Going to delete SmartExecutor Scheduled Task {}", (Object)uuid);
                boolean deleted = scheduler.deleteJob(jobKey);
                if (deleted) {
                    logger.debug("SmartExecutor Task {} deleted successfully", (Object)uuid);
                    break block11;
                }
                logger.debug("SmartExecutor Task {} was not deleted", (Object)uuid);
                throw new SchedulerRemoveException(uuid);
            }
            catch (SchedulerRemoveException e) {
                throw e;
            }
            catch (Exception e1) {
                throw new SchedulerRemoveException(uuid, (Throwable)e1);
            }
            finally {
                this.activeSchedulers.remove(uuid);
                try {
                    scheduler.clear();
                }
                catch (SchedulerException e) {
                    throw new SchedulerRemoveException(uuid, (Throwable)e);
                }
            }
        }
    }

    protected List<JobExecutionContext> getCurrentlyExecutingJobs(Scheduler scheduler) throws SchedulerException {
        logger.trace("Getting {} list", (Object)JobExecutionContext.class.getSimpleName());
        List cej = scheduler.getCurrentlyExecutingJobs();
        logger.trace("{} list got {}", (Object)JobExecutionContext.class.getSimpleName(), (Object)cej);
        return cej;
    }

    public LaunchParameter getLaunchParameter(Scheduler scheduler, JobKey jobKey) throws SchedulerException {
        JobDetail jobDetail = scheduler.getJobDetail(jobKey);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        return (LaunchParameter)jobDataMap.get((Object)"LAUNCH_PARAMETER");
    }

    protected void removeFromPersistence(boolean global, UUID uuid, boolean remove) throws SchedulePersistenceException {
        try {
            ScheduledTaskPersistence stc = ScheduledTaskPersistenceFactory.getScheduledTaskPersistence();
            if (remove) {
                logger.debug("Going to remove the SmartExecutor Scheduled Task {} from global scheduling", (Object)uuid);
                stc.removeScheduledTask(uuid);
            } else if (global) {
                logger.debug("Going to release the SmartExecutor Scheduled Task {}. The Task can be take in charge from another SmartExecutor instance", (Object)uuid);
                stc.releaseScheduledTask(uuid);
            } else {
                logger.debug("Going to remove the SmartExecutor Scheduled Task {} from local scheduling", (Object)uuid);
                stc.removeScheduledTask(uuid);
            }
        }
        catch (Exception e) {
            throw new SchedulePersistenceException(String.format("Unable to Remove Scheduled Task %s from global scheduling", uuid.toString()), (Throwable)e);
        }
    }

    public synchronized void stop(UUID uuid, boolean stopOnly, boolean remove) throws UnableToInterruptTaskException, SchedulerRemoveException, SchedulePersistenceException, SchedulerException {
        Scheduler scheduler = (Scheduler)this.activeSchedulers.get(uuid);
        if (scheduler == null) {
            logger.debug("No SmartExecutor Task {} was found. That's all folk.", (Object)uuid);
            this.removeFromPersistence(true, uuid, remove);
            return;
        }
        JobKey jobKey = new JobKey(uuid.toString());
        boolean exist = scheduler.checkExists(jobKey);
        if (!exist) {
            logger.trace("SmartExecutor Task {} does not have any instaces associated. Cleaning the environment. That's all folk.", (Object)uuid);
            this.activeSchedulers.remove(uuid);
            return;
        }
        logger.trace("SmartExecutor Task {} to stop exist", (Object)uuid);
        LaunchParameter launchParameter = this.getLaunchParameter(scheduler, jobKey);
        Scheduling scheduling = launchParameter.getScheduling();
        boolean scheduled = launchParameter.getScheduling() != null;
        this.stopLastcurrentExecution(scheduler, uuid);
        try {
            if (stopOnly ^ scheduled) {
                this.deleteScheduler(scheduler, uuid);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (!stopOnly && scheduled) {
                this.removeFromPersistence(scheduling.getGlobal().booleanValue(), uuid, remove);
            }
        }
    }

    public void stopAll() {
        ArrayList set = new ArrayList(this.activeSchedulers.keySet());
        for (UUID uuid : set) {
            try {
                this.stop(uuid, true, false);
            }
            catch (Exception e) {
                logger.error("Error stopping plugin instace with UUID {}", (Object)uuid, (Object)e);
            }
        }
    }
}

