/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor;

import java.util.UUID;
import javax.jws.WebService;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.vremanagement.executor.SmartExecutorInitializator;
import org.gcube.vremanagement.executor.api.SmartExecutor;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.LaunchException;
import org.gcube.vremanagement.executor.exception.PluginInstanceNotFoundException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.exception.SchedulePersistenceException;
import org.gcube.vremanagement.executor.exception.SchedulerNotFoundException;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceFactory;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorScheduler;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorSchedulerFactory;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="SmartExecutorPort", serviceName="gcube/vremanagement/smart-executor", targetNamespace="http://gcube-system.org/", endpointInterface="org.gcube.vremanagement.executor.api.SmartExecutor")
@ManagedBy(value=SmartExecutorInitializator.class)
public class SmartExecutorImpl
implements SmartExecutor {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorImpl.class);

    public String launch(LaunchParameter parameter) throws InputsNullException, PluginNotFoundException, LaunchException, ExecutorException {
        SmartExecutorScheduler smartExecutorScheduler;
        logger.info("Launch requested {}", (Object)parameter);
        try {
            smartExecutorScheduler = SmartExecutorSchedulerFactory.getSmartExecutorScheduler();
        }
        catch (SchedulerException e) {
            throw new ExecutorException((Throwable)e);
        }
        UUID uuid = smartExecutorScheduler.schedule(parameter, null);
        logger.info(String.format("The Plugin named %s with UUID %s has been launched %s", parameter.getPluginName(), uuid.toString(), parameter));
        return uuid.toString();
    }

    public boolean stop(String executionIdentifier) throws ExecutorException {
        logger.info("Receinved stop() for {}", (Object)executionIdentifier);
        boolean ret = this.unSchedule(executionIdentifier, false);
        logger.info("{} was{} stopped successfully", (Object)executionIdentifier, (Object)(ret ? "" : " NOT"));
        return ret;
    }

    public boolean unSchedule(String executionIdentifier, boolean globally) throws ExecutorException {
        logger.info("UnSchedule requested for {} globally : {}", (Object)executionIdentifier, (Object)globally);
        boolean ret = this.reallyUnSchedule(executionIdentifier, globally);
        logger.info("{} was{} unscheduled {} successfully", new Object[]{executionIdentifier, ret ? "" : " NOT", globally ? "globally" : "locally"});
        return ret;
    }

    protected boolean reallyUnSchedule(String executionIdentifier, boolean globally) throws ExecutorException {
        boolean currentStopped = true;
        try {
            SmartExecutorScheduler smartExecutorScheduler = SmartExecutorSchedulerFactory.getSmartExecutorScheduler();
            UUID uuid = UUID.fromString(executionIdentifier);
            smartExecutorScheduler.stop(uuid, globally);
        }
        catch (SchedulerNotFoundException e) {
            logger.error("Error unscheduling task {}", (Object)executionIdentifier, (Object)e);
            throw new ExecutorException((Throwable)e);
        }
        catch (SchedulerException e) {
            logger.error("Error unscheduling task {}", (Object)executionIdentifier, (Object)e);
            throw new ExecutorException((Throwable)e);
        }
        catch (SchedulePersistenceException e) {
            logger.error("Error removing scheduled task from persistence.", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Error unscheduling task {}", (Object)executionIdentifier, (Object)e);
            throw new ExecutorException((Throwable)e);
        }
        return currentStopped;
    }

    @Deprecated
    public PluginState getState(String executionIdentifier) throws PluginInstanceNotFoundException, ExecutorException {
        return this.getStateEvolution(executionIdentifier).getPluginState();
    }

    public PluginStateEvolution getStateEvolution(String executionIdentifier) throws PluginInstanceNotFoundException, ExecutorException {
        logger.info("getStateEvolution() requested for {}", (Object)executionIdentifier);
        try {
            SmartExecutorPersistenceConnector persistenceConnector = SmartExecutorPersistenceFactory.getPersistenceConnector();
            PluginStateEvolution pluginStateEvolution = persistenceConnector.getLastPluginInstanceState(UUID.fromString(executionIdentifier));
            logger.info("getState() for {} is : {}", (Object)executionIdentifier, (Object)pluginStateEvolution);
            return pluginStateEvolution;
        }
        catch (Exception e) {
            throw new PluginInstanceNotFoundException((Throwable)e);
        }
    }

    @Deprecated
    public PluginState getIterationState(String executionIdentifier, int iterationNumber) throws PluginInstanceNotFoundException, ExecutorException {
        return this.getIterationStateEvolution(executionIdentifier, iterationNumber).getPluginState();
    }

    public PluginStateEvolution getIterationStateEvolution(String executionIdentifier, int iterationNumber) throws PluginInstanceNotFoundException, ExecutorException {
        logger.info("getIterationStateEvolution() requested for {} (iteration n. {})", (Object)executionIdentifier, (Object)iterationNumber);
        try {
            SmartExecutorPersistenceConnector persistenceConnector = SmartExecutorPersistenceFactory.getPersistenceConnector();
            PluginStateEvolution pluginStateEvolution = persistenceConnector.getPluginInstanceState(UUID.fromString(executionIdentifier), iterationNumber);
            logger.info("getIterationState() for {} (iteration n. {}) is : {}", new Object[]{executionIdentifier, iterationNumber, pluginStateEvolution});
            return pluginStateEvolution;
        }
        catch (Exception e) {
            throw new PluginInstanceNotFoundException((Throwable)e);
        }
    }
}

