/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.pluginmanager;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static Logger logger = LoggerFactory.getLogger(PluginManager.class);
    private static PluginManager pluginManager;
    private Map<String, Class<? extends Plugin>> availablePlugins;
    private Map<String, UUID> uuids;

    public static synchronized PluginManager getInstance() {
        if (pluginManager == null) {
            pluginManager = new PluginManager();
        }
        return pluginManager;
    }

    protected PluginManager() {
        logger.debug("Loading plugins available on classpath");
        this.availablePlugins = new HashMap();
        this.uuids = new HashMap();
        ServiceLoader<Plugin> serviceLoader = ServiceLoader.load(Plugin.class);
        for (Plugin plugin : serviceLoader) {
            try {
                logger.debug(String.format("%s plugin found", plugin.getName()));
                String name = plugin.getName();
                this.availablePlugins.put(name, plugin.getClass());
                this.uuids.put(name, UUID.randomUUID());
            }
            catch (Exception e) {
                logger.debug(String.format("%s not initialized correctly. It will not be used", plugin.getName()));
            }
        }
    }

    public Plugin getPlugin(String pluginName) throws PluginNotFoundException, ExecutorException {
        Class pluginClass = (Class)this.getAvailablePlugins().get(pluginName);
        if (pluginClass == null) {
            throw new PluginNotFoundException("Plugin " + pluginName + " not available in this smart-executor instance");
        }
        try {
            return (Plugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ExecutorException("Unable to instatiate plugin " + pluginName, (Throwable)e);
        }
    }

    public UUID getPluginUUID(String pluginName) {
        return (UUID)this.uuids.get(pluginName);
    }

    public Map<String, Class<? extends Plugin>> getAvailablePlugins() {
        return this.availablePlugins;
    }
}

