/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.persistence.orientdb;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.PluginInstanceNotFoundException;
import org.gcube.vremanagement.executor.exception.SchedulePersistenceException;
import org.gcube.vremanagement.executor.json.ExtendedSEMapper;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConfiguration;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrientDBPersistenceConnector
extends SmartExecutorPersistenceConnector {
    private static final Logger logger = LoggerFactory.getLogger(OrientDBPersistenceConnector.class);
    protected static final String CONTEXT = "context";
    protected static final String UUID = "uuid";
    protected static final String ITERATION = "iteration";
    protected static final String TIMESTAMP = "timestamp";
    protected final String RUN_ON = "runOn";
    protected ODatabasePool oDatabasePool;

    public OrientDBPersistenceConnector(SmartExecutorPersistenceConfiguration configuration) throws Exception {
        this.prepareConnection(configuration);
    }

    protected void prepareConnection(SmartExecutorPersistenceConfiguration configuration) throws Exception {
        Orient.instance().removeShutdownHook();
        logger.debug("Preparing Connection for {}", (Object)this.getClass().getSimpleName());
        String url = configuration.getURL();
        String username = configuration.getUsername();
        String password = configuration.getPassword();
        this.oDatabasePool = new ODatabasePool(url, username, password);
    }

    public void close() throws Exception {
        this.oDatabasePool.close();
        this.oDatabasePool = null;
    }

    public PluginStateEvolution getPluginInstanceState(UUID uuid, Integer iterationNumber) throws PluginInstanceNotFoundException, ExecutorException {
        ODatabaseSession oDatabaseSession = null;
        try {
            PluginStateEvolution pluginStateEvolution;
            oDatabaseSession = this.oDatabasePool.acquire();
            String type = PluginStateEvolution.class.getSimpleName();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(UUID, uuid.toString());
            params.put(CONTEXT, SecretManagerProvider.get().getContext());
            OSQLSynchQuery query = null;
            if (iterationNumber != null && iterationNumber > 0) {
                query = new OSQLSynchQuery("SELECT FROM %s WHERE %s = :%s AND %s = :%s AND %s = :%s ORDER BY %s DESC LIMIT 1".formatted(type, CONTEXT, CONTEXT, UUID, UUID, ITERATION, ITERATION, TIMESTAMP));
                params.put(ITERATION, iterationNumber);
            } else {
                query = new OSQLSynchQuery("SELECT FROM %s WHERE %s = :%s AND %s = :%s ORDER BY %s DESC, %s DESC LIMIT 1".formatted(type, CONTEXT, CONTEXT, UUID, UUID, ITERATION, TIMESTAMP));
            }
            List result = (List)query.execute(new Object[]{params});
            ODocument resDoc = (ODocument)result.get(0);
            String json = resDoc.toJSON("class");
            PluginStateEvolution pluginStateEvolution2 = pluginStateEvolution = (PluginStateEvolution)ExtendedSEMapper.getInstance().unmarshal(PluginStateEvolution.class, json);
            return pluginStateEvolution2;
        }
        catch (Exception e) {
            throw new PluginInstanceNotFoundException(uuid);
        }
        finally {
            this.closeDatabaseSession(oDatabaseSession);
        }
    }

    public void pluginStateEvolution(PluginStateEvolution pluginStateEvolution, Exception exception) throws Exception {
        ODatabaseSession oDatabaseSession = null;
        try {
            oDatabaseSession = this.oDatabasePool.acquire();
            ODocument doc = new ODocument(PluginStateEvolution.class.getSimpleName());
            String json = ExtendedSEMapper.getInstance().marshal((Object)pluginStateEvolution);
            doc.fromJSON(json);
            doc.field(CONTEXT, (Object)SecretManagerProvider.get().getContext());
            doc.save();
            oDatabaseSession.commit();
        }
        catch (Exception e) {
            if (oDatabaseSession != null) {
                oDatabaseSession.rollback();
            }
            throw e;
        }
        finally {
            this.closeDatabaseSession(oDatabaseSession);
        }
    }

    public void addScheduledTask(ScheduledTask scheduledTask) throws SchedulePersistenceException {
        ODatabaseSession oDatabaseSession = null;
        try {
            oDatabaseSession = this.oDatabasePool.acquire();
            ODocument doc = new ODocument(ScheduledTask.class.getSimpleName());
            long timestamp = Calendar.getInstance().getTimeInMillis();
            doc.field(TIMESTAMP, (Object)timestamp);
            String json = ExtendedSEMapper.getInstance().marshal((Object)scheduledTask);
            doc.fromJSON(json);
            doc.save();
            oDatabaseSession.commit();
        }
        catch (Exception e) {
            if (oDatabaseSession != null) {
                oDatabaseSession.rollback();
            }
            throw new SchedulePersistenceException((Throwable)e);
        }
        finally {
            this.closeDatabaseSession(oDatabaseSession);
        }
    }

    public List<ScheduledTask> getScheduledTasks(Collection<String> plugins) throws SchedulePersistenceException {
        ODatabaseSession oDatabaseSession = null;
        try {
            oDatabaseSession = this.oDatabasePool.acquire();
            String type = ScheduledTask.class.getSimpleName();
            Object queryString = "SELECT * FROM %s WHERE %s = '%s'".formatted(type, CONTEXT, SecretManagerProvider.get().getContext());
            if (plugins != null && plugins.size() != 0) {
                boolean first = true;
                for (String pluginName : plugins) {
                    if (first) {
                        first = false;
                        queryString = "%s AND ( (%s = '%s') ".formatted(queryString, "launchParameter.pluginName", pluginName);
                        continue;
                    }
                    queryString = "%s OR (%s = '%s') ".formatted(queryString, "launchParameter.pluginName", pluginName);
                }
                queryString = (String)queryString + ")";
            }
            OSQLSynchQuery query = new OSQLSynchQuery((String)queryString);
            List result = (List)query.execute(new Object[0]);
            ArrayList<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();
            for (ODocument doc : result) {
                String json = doc.toJSON("class");
                ScheduledTask scheduledTask = (ScheduledTask)ExtendedSEMapper.getInstance().unmarshal(ScheduledTask.class, json);
                scheduledTasks.add(scheduledTask);
            }
            ArrayList<ScheduledTask> arrayList = scheduledTasks;
            return arrayList;
        }
        catch (Exception e) {
            throw new SchedulePersistenceException((Throwable)e);
        }
        finally {
            this.closeDatabaseSession(oDatabaseSession);
        }
    }

    protected ODocument getScheduledTaskDocument(UUID uuid) throws SchedulePersistenceException {
        try {
            String type = ScheduledTask.class.getSimpleName();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(UUID, uuid.toString());
            OSQLSynchQuery query = new OSQLSynchQuery("SELECT FROM %s WHERE %s = :%s".formatted(type, UUID, UUID));
            List result = (List)query.execute(new Object[]{params});
            if (result.size() > 1) {
                String error = "Found more than one %s with UUID=%s. %s. %s.".formatted(type, uuid.toString(), "This is really strange and should not occur", "Please contact the smart-executor administrator");
                logger.error(error);
                throw new SchedulePersistenceException(error);
            }
            if (result.size() == 0) {
                String error = "No %s with UUID=%s found.".formatted(type, uuid.toString());
                logger.error(error);
                throw new SchedulePersistenceException(error);
            }
            return (ODocument)result.get(0);
        }
        catch (Exception e) {
            throw new SchedulePersistenceException((Throwable)e);
        }
    }

    public ScheduledTask getScheduledTask(UUID uuid) throws SchedulePersistenceException {
        ODatabaseSession oDatabaseSession = null;
        try {
            oDatabaseSession = this.oDatabasePool.acquire();
            ODocument doc = this.getScheduledTaskDocument(uuid);
            String json = doc.toJSON("class");
            ScheduledTask scheduledTask = (ScheduledTask)ExtendedSEMapper.getInstance().unmarshal(ScheduledTask.class, json);
            return scheduledTask;
        }
        catch (Exception e) {
            throw new SchedulePersistenceException((Throwable)e);
        }
        finally {
            this.closeDatabaseSession(oDatabaseSession);
        }
    }

    public void reserveScheduledTask(ScheduledTask scheduledTask) throws SchedulePersistenceException {
        this.releaseScheduledTask(scheduledTask);
    }

    public void removeScheduledTask(UUID uuid) throws SchedulePersistenceException {
        ODatabaseSession oDatabaseSession = null;
        try {
            oDatabaseSession = this.oDatabasePool.acquire();
            ODocument doc = this.getScheduledTaskDocument(uuid);
            doc.delete();
            oDatabaseSession.commit();
        }
        catch (Exception e) {
            if (oDatabaseSession != null) {
                oDatabaseSession.rollback();
            }
            throw new SchedulePersistenceException((Throwable)e);
        }
        finally {
            this.closeDatabaseSession(oDatabaseSession);
        }
    }

    public void removeScheduledTask(ScheduledTask scheduledTask) throws SchedulePersistenceException {
        this.removeScheduledTask(scheduledTask.getUUID());
    }

    public void releaseScheduledTask(UUID uuid) throws SchedulePersistenceException {
        ODatabaseSession oDatabaseSession = null;
        try {
            oDatabaseSession = this.oDatabasePool.acquire();
            ODocument doc = this.getScheduledTaskDocument(uuid);
            doc.removeField("runOn");
            doc.save();
        }
        catch (Exception e) {
            if (oDatabaseSession != null) {
                oDatabaseSession.rollback();
            }
            throw new SchedulePersistenceException((Throwable)e);
        }
        finally {
            this.closeDatabaseSession(oDatabaseSession);
        }
    }

    private void closeDatabaseSession(ODatabaseSession oDatabaseSession) {
        if (oDatabaseSession != null) {
            oDatabaseSession.close();
            oDatabaseSession = null;
        }
    }

    public void releaseScheduledTask(ScheduledTask scheduledTask) throws SchedulePersistenceException {
        this.releaseScheduledTask(scheduledTask.getUUID());
    }

    public static void shutdown() {
        Orient.instance().shutdown();
    }
}

