/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo.impl;

import com.hp.hpl.jena.rdf.model.Resource;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.grade.configuration.QueryConfiguration;
import org.grade.repo.Endpoints;
import org.grade.repo.Queries;
import org.grade.repo.RdfRepository;
import org.grade.repo.Repository;

public class AbstractRepositoryDelegate<T>
implements Repository<T> {
    protected final RdfRepository repo;
    private final Function<Resource, T> binder;

    public AbstractRepositoryDelegate(RdfRepository repo, Function<Resource, T> binder) {
        this.repo = repo;
        this.binder = binder;
    }

    private Predicate<Resource> bindableWith(Function<Resource, T> binder) {
        return $ -> {
            try {
                binder.apply((Resource)$);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        };
    }

    @Override
    public List<T> get(String query, Map<String, String> args) {
        return this.repo.get(query, args).stream().filter(this.bindableWith(this.binder)).map(this.binder).collect(Collectors.toList());
    }

    @Override
    public List<T> get(QueryConfiguration query, Map<String, String> args) {
        return this.repo.get(query, args).stream().map(this.binder).collect(Collectors.toList());
    }

    @Override
    public <S> S execute(QueryConfiguration config, Map<String, String> args) {
        return (S)this.repo.execute(config, args);
    }

    @Override
    public <S> S execute(String name, Map<String, String> args) {
        return (S)this.repo.execute(name, args);
    }

    @Override
    public Endpoints endpoints() {
        return this.repo.endpoints();
    }

    @Override
    public Queries queries() {
        return this.repo.queries();
    }
}

