/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo.impl.memory;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.vocabulary.FOAF;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDFS;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import org.grade.common.annotation.Qualifiers;
import org.grade.repo.Endpoint;
import org.grade.repo.GenericRepository;
import org.grade.repo.Task;
import org.grade.repo.utils.TestUtils;

@ApplicationScoped
public class MemoryModels {
    @Produces
    @Qualifiers.Production
    public Resource model1() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://graphs/graph1").addProperty(RDFS.label, "Dataset One");
        model.createResource("http://ress/1").addProperty(DCTerms.title, "Resource One");
        model.createResource("http://people/claudio.baldassarre").addProperty(DCTerms.title, "Claudio Baldassarre");
        return resource;
    }

    @Produces
    @Qualifiers.Production
    public Resource model2() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://graphs/graph2").addProperty(RDFS.label, "Dataset Two");
        model.createResource("http://ress/2").addProperty(DCTerms.title, "Resource Two");
        model.createResource("http://people/federico.defaveri").addProperty(FOAF.name, "Federico DeFaveri");
        return resource;
    }

    @Produces
    @Qualifiers.Staging
    public Resource model3() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://graphs/graph3").addProperty(RDFS.label, "Dataset Three");
        model.createResource("http://ress/3").addProperty(DCTerms.title, "Resource Three");
        model.createResource("http://people/fabio.simeoni").addProperty(FOAF.name, "Fabio Simeoni");
        return resource;
    }

    @Produces
    @Qualifiers.Staging
    public Resource model4() {
        Model model = ModelFactory.createDefaultModel();
        Resource empty = model.createResource("http://graphs/graph4");
        return empty;
    }

    @Produces
    @Qualifiers.Tasks
    public Task task1(@Qualifiers.Staging GenericRepository staging, @Qualifiers.Production GenericRepository production) {
        Endpoint source = staging.endpoints().all().get(0);
        Endpoint target = production.endpoints().all().get(0);
        return TestUtils.somePublishTask(source, target);
    }

    @Produces
    @Qualifiers.Tasks
    public Task task2(@Qualifiers.Staging GenericRepository staging, @Qualifiers.Production GenericRepository production) {
        Endpoint source = staging.endpoints().all().get(0);
        Endpoint target = production.endpoints().all().get(0);
        return TestUtils.someAddTask(source, target);
    }

    @Produces
    @Qualifiers.Tasks
    public Task task3(@Qualifiers.Staging GenericRepository staging, @Qualifiers.Production GenericRepository production) {
        Endpoint source = staging.endpoints().all().get(0);
        Endpoint target = production.endpoints().all().get(0);
        return TestUtils.someRemoveTask(source, target);
    }

    @Produces
    @Qualifiers.Production
    public Dataset prodstore(@Qualifiers.Production Instance<Resource> resources) {
        return this.datasetWithGraphsFor(resources);
    }

    @Produces
    @Qualifiers.Staging
    public Dataset uploadstore() {
        return DatasetFactory.createMem();
    }

    @Produces
    @Qualifiers.Upload
    public Dataset stagestore(@Qualifiers.Staging Instance<Resource> resources) {
        return this.datasetWithGraphsFor(resources);
    }

    @Produces
    @Qualifiers.Tasks
    public Dataset taskstore(@Qualifiers.Tasks Instance<Task> tasks) {
        Dataset set = DatasetFactory.createMem();
        for (Task task : tasks) {
            set.addNamedModel(task.graphUri(), task.resource().getModel());
        }
        return set;
    }

    private Dataset datasetWithGraphsFor(Instance<Resource> resources) {
        Dataset set = DatasetFactory.createMem();
        for (Resource resource : resources) {
            set.addNamedModel(resource.getURI(), resource.getModel());
        }
        return set;
    }
}

