/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.NonNull;
import org.grade.configuration.QueryConfiguration;
import org.grade.repo.Endpoint;
import org.grade.repo.utils.RepositoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query {
    private static final Logger log = LoggerFactory.getLogger(Query.class);
    final QueryConfiguration cfg;
    final Type type;

    public static Query queryWith(@NonNull QueryConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        String ex = config.expression().toLowerCase();
        for (Type type : Type.values()) {
            if (!ex.contains(type.name().toLowerCase())) continue;
            return new Query(config, type);
        }
        throw new IllegalArgumentException("unsupported type for query: " + ex);
    }

    private Query(QueryConfiguration cfg, Type type) {
        this.cfg = cfg;
        this.type = type;
    }

    public <T> T evalAt(Endpoint e) {
        return this.evalAt(e, Collections.emptyMap());
    }

    public <T> T evalAt(Endpoint e, Map<String, String> args) {
        return this.evalAt(e, args, this.cfg.graphs());
    }

    public <T> T evalAt(Endpoint e, Map<String, String> args, Collection<String> defaultGraphs) {
        com.hp.hpl.jena.query.Query q = RepositoryUtils.parse(this.expression(), args);
        log.trace("instantiated query '{}' in: \n\n{}\n\n", (Object)this.name(), (Object)q);
        if (defaultGraphs.isEmpty()) {
            defaultGraphs = this.cfg.graphs();
        }
        if (defaultGraphs.isEmpty()) {
            try (QueryExecution exec = e.executionFor(q);){
                Object object = this.type.resultsOf(exec);
                return (T)object;
            }
        }
        log.trace("executing {} against default graphs {}", (Object)this.name(), (Object)defaultGraphs);
        try (QueryExecution exec = e.executionFor(q, new ArrayList<String>(defaultGraphs));){
            Object object = this.type.resultsOf(exec);
            return (T)object;
        }
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return this.cfg.toString();
    }

    public String id() {
        return this.cfg.id();
    }

    public String name() {
        return this.cfg.name();
    }

    public QueryConfiguration.Status status() {
        return this.cfg.status();
    }

    public String endpoint() {
        return this.cfg.endpoint();
    }

    public Set<String> graphs() {
        return this.cfg.graphs();
    }

    public String expression() {
        return this.cfg.expression();
    }

    public String note() {
        return this.cfg.note();
    }

    public QueryConfiguration id(String arg0) {
        return this.cfg.id(arg0);
    }

    public QueryConfiguration name(String arg0) {
        return this.cfg.name(arg0);
    }

    public QueryConfiguration status(QueryConfiguration.Status arg0) {
        return this.cfg.status(arg0);
    }

    public QueryConfiguration endpoint(String arg0) {
        return this.cfg.endpoint(arg0);
    }

    public QueryConfiguration graphs(Set<String> arg0) {
        return this.cfg.graphs(arg0);
    }

    public QueryConfiguration expression(String arg0) {
        return this.cfg.expression(arg0);
    }

    public QueryConfiguration note(String note) {
        return this.cfg.note(note);
    }

    public static enum Type {
        CONSTRUCT($ -> $.execConstruct(), Model.class),
        DESCRIBE($ -> $.execDescribe(), Model.class),
        SELECT($ -> ResultSetFactory.copyResults((ResultSet)$.execSelect()), ResultSet.class);

        private final Function<QueryExecution, Object> evaluator;
        private final Class<?> runtime_type;

        private Type(Function<QueryExecution, Object> evaluator, Class<?> runtime_type) {
            this.evaluator = evaluator;
            this.runtime_type = runtime_type;
        }

        Object resultsOf(QueryExecution ex) {
            return this.evaluator.apply(ex);
        }

        public boolean returns(Class<?> type) {
            return type.isAssignableFrom(this.runtime_type);
        }
    }
}

