/*
 * Decompiled with CFR 0.152.
 */
package org.dynamicvalues;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.dynamicvalues.Exclusion;
import org.dynamicvalues.Mapping;

public class Directives {
    private final List<Exclusion> excludes = new ArrayList<Exclusion>();
    private final List<Mapping> mappings = new ArrayList<Mapping>();

    public static Directives by() {
        return new Directives();
    }

    private Directives() {
    }

    public Directives excluding(Exclusion ... directives) {
        return this.excluding(Arrays.asList(directives));
    }

    public Directives excluding(List<Exclusion> directives) {
        this.excludes.addAll(directives);
        return this;
    }

    public Directives mapping(List<Mapping> directives) {
        this.mappings.addAll(directives);
        return this;
    }

    public Directives mapping(Mapping ... directives) {
        return this.mapping(Arrays.asList(directives));
    }

    List<Exclusion> excludes() {
        return this.excludes;
    }

    List<Mapping> mappings() {
        return this.mappings;
    }

    public static Exclusion not(final Exclusion directive) {
        return new Exclusion(){

            @Override
            public boolean exclude(Object object, Field field) throws Exception {
                return !directive.exclude(object, field);
            }
        };
    }

    public static Exclusion all(final Exclusion ... directives) {
        return new Exclusion(){

            @Override
            public boolean exclude(Object object, Field field) throws Exception {
                for (Exclusion directive : directives) {
                    if (directive.exclude(object, field)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Exclusion annotation(final Class<? extends Annotation> annotation) {
        return new Exclusion(){

            @Override
            public boolean exclude(Object object, Field field) {
                return field.isAnnotationPresent(annotation);
            }
        };
    }

    public static Exclusion type(final Class<?> type) {
        return new Exclusion(){

            @Override
            public boolean exclude(Object object, Field field) {
                return type.isAssignableFrom(field.getType());
            }
        };
    }

    public static Exclusion object(final Object o) {
        return new Exclusion(){

            @Override
            public boolean exclude(Object object, Field field) {
                return object == o;
            }
        };
    }

    public static Exclusion value(final Object value) {
        return new Exclusion(){

            @Override
            public boolean exclude(Object object, Field field) throws Exception {
                field.setAccessible(true);
                Object val = field.get(object);
                return val != null && val == value;
            }
        };
    }

    public static Exclusion objectLike(final Object parent) {
        return new Exclusion(){

            @Override
            public boolean exclude(Object object, Field field) {
                return object.equals(parent);
            }
        };
    }

    public static Exclusion valueLike(final Object value) {
        return new Exclusion(){

            @Override
            public boolean exclude(Object object, Field field) throws Exception {
                field.setAccessible(true);
                Object val = field.get(object);
                return val != null && val.equals(value);
            }
        };
    }

    public static Exclusion name(final String name) {
        return new Exclusion(){

            @Override
            public boolean exclude(Object object, Field field) throws Exception {
                return field.getName().equals(name);
            }
        };
    }

    public static Exclusion name(final Pattern pattern) {
        return new Exclusion(){

            @Override
            public boolean exclude(Object object, Field field) throws Exception {
                return pattern.matcher(field.getName()).matches();
            }
        };
    }

    public static Exclusion emptyStrings() {
        return new Exclusion(){

            @Override
            public boolean exclude(Object object, Field field) throws Exception {
                String val;
                return field.getType() == String.class && (val = (String)String.class.cast(field.get(object))) != null && val.isEmpty();
            }
        };
    }

    public static Mapping objectsToStringFor(final Class<?> type) {
        return new Mapping(){

            @Override
            public Object map(Object parent, Field field, Object value) throws Exception {
                return value.getClass().isAssignableFrom(type) ? value.toString() : null;
            }
        };
    }

    public static Mapping classesOntoSimpleNames() {
        return new Mapping(){

            @Override
            public Object map(Object parent, Field field, Object value) throws Exception {
                return value instanceof Class ? ((Class)Class.class.cast(value)).getSimpleName() : null;
            }
        };
    }
}

