/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.data.fao.resources;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import org.virtual.data.fao.resources.LocalisedValue;
import org.virtualrepository.Property;

public abstract class AbstractResource {
    @XmlElement(name="label")
    private List<LocalisedValue> names;
    @XmlElement
    private URI urn;
    @XmlElement
    private URI uri;
    @XmlElement
    private String uuid;
    @XmlElement
    private String mnemonic;
    @XmlElement(name="description")
    private List<LocalisedValue> descriptions;
    List<Property> properties = new ArrayList<Property>();

    public URI urn() {
        return this.urn;
    }

    public URI uri() {
        return this.uri;
    }

    public String uuid() {
        return this.uuid;
    }

    public abstract String name();

    public List<LocalisedValue> names() {
        return this.names;
    }

    public List<LocalisedValue> descriptions() {
        return this.descriptions;
    }

    public String mnemonic() {
        return this.mnemonic;
    }

    public Property[] properties() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    public String toString() {
        return "name=" + this.name() + ", urn=" + this.urn + ", uri=" + this.uri + ", properties=" + this.properties;
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.names != null) {
            for (LocalisedValue name : this.names) {
                this.properties.add(new Property(String.format("name", name.lang() == null ? "" : "-" + name.lang()), (Object)name.value()));
            }
        }
        if (this.descriptions != null) {
            for (LocalisedValue description : this.descriptions) {
                this.properties.add(new Property(String.format("description%s", description.lang() == null ? "" : "-" + description.lang()), (Object)description.value()));
            }
        }
        this.properties.add(new Property("uri", (Object)this.uri));
        this.properties.add(new Property("urn", (Object)this.urn));
        this.properties.add(new Property("uuid", (Object)this.uuid, false));
    }
}

