/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files.local;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.files.Provider;
import org.virtual.files.common.Utils;
import org.virtual.files.index.AssetIndex;
import org.virtual.files.index.AssetInfo;
import org.virtual.files.local.LocalConfiguration;
import org.virtualrepository.Asset;

public class LocalProvider
implements Provider {
    private static final Logger log = LoggerFactory.getLogger(LocalProvider.class);
    private AssetIndex index;
    private LocalConfiguration configuration;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public LocalProvider(@NonNull LocalConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        this.configuration = configuration;
        this.connectTo(this.indexfile());
    }

    @Override
    public void validate(AssetInfo asset) {
        Utils.valid(this.contentfileOf(asset));
    }

    @Override
    public synchronized InputStream load(@NonNull AssetInfo asset) {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        return new FileInputStream(this.contentfileOf(asset));
    }

    @Override
    public synchronized void update(Asset asset, AssetInfo info, InputStream contents) {
        this.store(this.contentfileOf(info), contents);
        this.store(this.indexfile());
    }

    @Override
    public synchronized void create(Asset asset, AssetInfo info, InputStream contents) {
        File file = this.contentfileOf(info);
        this.store(file, contents);
        this.index.assets().add(info);
        try {
            this.store(this.indexfile());
        }
        catch (RuntimeException e) {
            if (!file.delete()) {
                log.error("cannot delete {} after failed publication", (Object)file);
            }
            throw e;
        }
    }

    public String toString() {
        return this.configuration.name() + "@" + this.configuration.location();
    }

    private File indexfile() {
        return new File(this.configuration.location(), "vindex.json");
    }

    private File contentfileOf(AssetInfo entry) {
        return new File(this.configuration.location(), entry.path());
    }

    private void connectTo(File indexfile) {
        this.index = this.parse(indexfile);
        this.executor.execute(new Watcher(indexfile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AssetIndex parse(File indexfile) {
        AssetIndex assetIndex;
        block6: {
            FileInputStream stream = new FileInputStream(indexfile);
            try {
                assetIndex = (AssetIndex)Utils.mapper.readValue((InputStream)stream, AssetIndex.class);
                if (Collections.singletonList(stream).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(stream).get(0) != null) {
                        stream.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw Utils.unchecked("cannot load index file", e);
                }
            }
            stream.close();
        }
        return assetIndex;
    }

    void store(File indexfile) {
        try {
            FileOutputStream stream = new FileOutputStream(indexfile);
            try {
                Utils.mapper.writeValue((OutputStream)stream, (Object)this.index);
            }
            finally {
                if (Collections.singletonList(stream).get(0) != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            throw Utils.unchecked("cannot update index file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(File file, InputStream stream) {
        new File(file.getAbsolutePath()).getParentFile().mkdirs();
        try {
            byte[] bytes = new byte[2048];
            FileOutputStream out = new FileOutputStream(file);
            try {
                int read = 0;
                while ((read = stream.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
                out.flush();
            }
            finally {
                if (Collections.singletonList(out).get(0) != null) {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            throw Utils.unchecked(this + ": cannot store asset in " + file, e);
        }
    }

    @Override
    public AssetIndex index() {
        return this.index;
    }

    @Override
    public LocalConfiguration configuration() {
        return this.configuration;
    }

    class Watcher
    implements Runnable {
        private final File indexfile;

        @Override
        public void run() {
            try {
                WatchService watcher = FileSystems.getDefault().newWatchService();
                try {
                    Path indexpath = Paths.get(this.indexfile.getPath(), new String[0]);
                    Path parentpath = indexpath.getParent();
                    parentpath.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
                    block4: while (true) {
                        WatchKey key = watcher.take();
                        Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                        while (true) {
                            boolean valid;
                            if (!iterator.hasNext()) continue block4;
                            WatchEvent<?> event = iterator.next();
                            if (event.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                            WatchEvent<?> ev = event;
                            if (indexpath.equals(parentpath.resolve((Path)ev.context()))) {
                                log.info("detected change to index for {}: reparsing", (Object)LocalProvider.this);
                                LocalProvider.this.index = LocalProvider.this.parse(this.indexfile);
                            }
                            if (!(valid = key.reset())) break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(watcher).get(0) != null) {
                        watcher.close();
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error("error whilst watching " + this.indexfile, (Throwable)e);
                return;
            }
        }

        @ConstructorProperties(value={"indexfile"})
        public Watcher(File indexfile) {
            this.indexfile = indexfile;
        }
    }
}

