/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.workspace.types;

import java.io.InputStream;
import java.util.Map;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.virtual.workspace.types.WorkspaceType;
import org.virtual.workspace.utils.Tags;
import org.virtualrepository.Asset;
import org.virtualrepository.Property;
import org.virtualrepository.impl.Type;
import org.virtualrepository.spi.MutableAsset;
import org.virtualrepository.spi.Transform;

public abstract class AbstractWorkspaceType<T extends MutableAsset, A>
implements WorkspaceType {
    private final Type<T> type;
    private final String mime;

    public AbstractWorkspaceType(Type<T> type, String mime) {
        this.type = type;
        this.mime = mime;
    }

    public Type<T> assetType() {
        return this.type;
    }

    @Override
    public String mime() {
        return this.mime;
    }

    public T toAsset(WorkspaceItem item) throws Exception {
        T asset = this.getAsset(item);
        asset.setVersion((String)item.getProperties().getProperties().get((Object)Tags.VERSION));
        for (Map.Entry entry : item.getProperties().getProperties().entrySet()) {
            asset.properties().add(new Property[]{new Property((String)entry.getKey(), entry.getValue())});
        }
        return asset;
    }

    @Override
    public void toItem(Asset asset, Properties props) throws Exception {
    }

    protected abstract T getAsset(WorkspaceItem var1) throws Exception;

    public abstract Transform<T, InputStream, A> fromStream();

    public abstract Transform<T, A, InputStream> toStream();

    public String toString() {
        boolean read = this.fromStream() != null;
        boolean write = this.toStream() != null;
        return String.format("%s (%s|%s: %s)", this.type, read ? "R" : "-", write ? "W" : "-", this.tags());
    }
}

