/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.ows;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.virtual.ows.OwsBrowser;
import org.virtual.ows.WfsClient;
import org.virtual.ows.WfsRawReader;
import org.virtual.ows.WfsReader;
import org.virtual.ows.profile.Wfs100Profile;
import org.virtual.ows.profile.Wfs110Profile;
import org.virtual.ows.profile.Wfs200Profile;
import org.virtual.ows.profile.WfsProfile;
import org.virtualrepository.spi.Importer;
import org.virtualrepository.spi.Publisher;
import org.virtualrepository.spi.ServiceProxy;

public class OwsProxy
implements ServiceProxy {
    private final OwsBrowser browser;
    private final List<? extends Importer<?, ?>> importers;
    private WfsProfile profile;

    public OwsProxy(@NonNull WfsClient client) {
        if (client == null) {
            throw new IllegalArgumentException("client is null");
        }
        this.profile = this.profileFor(client);
        this.browser = new OwsBrowser(this.profile, client);
        this.importers = Arrays.asList(new WfsRawReader(client), new WfsReader(client));
    }

    public List<? extends Publisher<?, ?>> publishers() {
        return Collections.emptyList();
    }

    public WfsProfile profileFor(WfsClient client) {
        switch (client.service().version()) {
            case v100: {
                return new Wfs100Profile(client);
            }
            case v200: {
                return new Wfs200Profile(client);
            }
        }
        return new Wfs110Profile(client);
    }

    public OwsBrowser browser() {
        return this.browser;
    }

    public List<? extends Importer<?, ?>> importers() {
        return this.importers;
    }

    public WfsProfile profile() {
        return this.profile;
    }
}

