/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository.csv;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.virtualrepository.Property;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.Utils;
import org.virtualrepository.csv.CsvGenericType;
import org.virtualrepository.impl.AbstractAsset;
import org.virtualrepository.impl.Type;
import org.virtualrepository.tabular.Column;

public class CsvAsset
extends AbstractAsset {
    public static final char defaultDelimiter = ',';
    public static final char defaultQuote = '\"';
    public static final String defaultEncoding = "UTF-8";
    public static final boolean defaultHeader = false;
    public static final long defaultRows = Long.MAX_VALUE;
    public static final Type<CsvAsset> type = new CsvGenericType();
    private char delimiter = (char)44;
    private char quote = (char)34;
    private boolean header = false;
    private String encoding = "UTF-8";
    private List<Column> columns = new ArrayList<Column>();
    private long rows = Long.MAX_VALUE;

    protected <T extends CsvAsset> CsvAsset(Type<T> type, String id, String name, Property ... properties) {
        super(type, id, name, properties);
    }

    public <T extends CsvAsset> CsvAsset(String id, String name, Property ... properties) {
        this(type, id, name, properties);
    }

    protected <T extends CsvAsset> CsvAsset(Type<T> type, String id, String name, RepositoryService service, Property ... properties) {
        super(type, id, name, service, properties);
    }

    protected <T extends CsvAsset> CsvAsset(Type<T> type, String name, RepositoryService service, Property ... properties) {
        super(type, name, service, properties);
    }

    public <T extends CsvAsset> CsvAsset(String name, RepositoryService service, Property ... properties) {
        super(type, name, service, properties);
    }

    public <T extends CsvAsset> CsvAsset(String name, String id, RepositoryService service, Property ... properties) {
        super(type, id, name, service, properties);
    }

    public char delimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public char quote() {
        return this.quote;
    }

    public void setQuote(char quote) {
        this.quote = quote;
    }

    public boolean hasHeader() {
        return this.header;
    }

    public void hasHeader(boolean header) {
        this.header = header;
    }

    public Charset encoding() {
        return Charset.forName(this.encoding);
    }

    public void setEncoding(Charset encoding) {
        Utils.notNull("encoding", encoding);
        this.encoding = encoding.name();
    }

    public List<Column> columns() {
        return this.columns;
    }

    public void setRows(long rows) {
        Utils.notNull("rows", rows);
        this.rows = rows;
    }

    public Long rows() {
        return this.rows;
    }

    public void setColumns(Column ... columns) {
        Utils.notNull("columns", columns);
        this.columns = new ArrayList<Column>(Arrays.asList(columns));
    }

    @Override
    public String toString() {
        int maxLen = 100;
        return this.type().name() + " [delimiter=" + this.delimiter + ", quote=" + this.quote + ", header=" + this.header + ", encoding=" + this.encoding + ", columns=" + (this.columns != null ? this.columns.subList(0, Math.min(this.columns.size(), 100)) : null) + ", rows=" + this.rows + ", id()=" + this.id() + ", type()=" + this.type() + ", service()=" + this.service() + ", name()=" + this.name() + ", properties()=" + this.properties() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + this.delimiter;
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.header ? 1231 : 1237);
        result = 31 * result + this.quote;
        result = 31 * result + (int)(this.rows ^ this.rows >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CsvAsset other = (CsvAsset)obj;
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        if (this.delimiter != other.delimiter) {
            return false;
        }
        if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
            return false;
        }
        if (this.header != other.header) {
            return false;
        }
        if (this.quote != other.quote) {
            return false;
        }
        return this.rows == other.rows;
    }
}

