/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.Utils;
import org.virtualrepository.spi.Lifecycle;
import org.virtualrepository.spi.Plugin;

public class Services
implements Iterable<RepositoryService> {
    public static Logger log = LoggerFactory.getLogger(Services.class);
    private final Map<QName, RepositoryService> services = new HashMap<QName, RepositoryService>();

    public Services() {
    }

    public Services(RepositoryService ... services) {
        this.add(services);
    }

    public int add(RepositoryService ... services) {
        Utils.notNull("repository services", services);
        int added = 0;
        for (RepositoryService service : services) {
            Utils.notNull("repository service", service);
            QName name = service.name();
            if (this.contains(name)) {
                log.warn("repository service {} ({}) overwrites service with the same name ({})", new Object[]{service.name(), service, this.lookup(service.name())});
            }
            if (service.proxy() instanceof Lifecycle) {
                try {
                    ((Lifecycle)Lifecycle.class.cast(service.proxy())).init();
                }
                catch (Exception e) {
                    log.error("repository service {} cannot be activated and will be discarded", (Throwable)e);
                    continue;
                }
            }
            this.validate(service);
            this.services.put(service.name(), service);
            log.info("added repository service {} ({})", (Object)service.name(), (Object)service);
            ++added;
        }
        return added;
    }

    public void load() {
        ServiceLoader<Plugin> plugins = ServiceLoader.load(Plugin.class);
        int pluginCount = 0;
        int serviceCount = 0;
        for (Plugin plugin : plugins) {
            try {
                Collection<RepositoryService> services;
                if (plugin instanceof Lifecycle) {
                    ((Lifecycle)Lifecycle.class.cast(plugin)).init();
                }
                if ((services = plugin.services()) == null || services.isEmpty()) {
                    log.error("plugin {} exports no repository services and will be ignored", plugin.getClass());
                    continue;
                }
                ++pluginCount;
                for (RepositoryService service : services) {
                    serviceCount += this.add(service);
                }
            }
            catch (Exception e) {
                log.error("plugin " + plugin.getClass() + " cannot be activated and will be discarded", (Throwable)e);
            }
        }
        log.info("loaded {} repository service(s) from {} plugin(s)", (Object)serviceCount, (Object)pluginCount);
    }

    public boolean contains(QName name) {
        Utils.notNull(name);
        return this.services.containsKey(name);
    }

    public RepositoryService lookup(QName name) {
        Utils.notNull(name);
        if (this.services.containsKey(name)) {
            return this.services.get(name);
        }
        throw new IllegalStateException("source " + name + " is unknown");
    }

    public int size() {
        return this.services.size();
    }

    @Override
    public Iterator<RepositoryService> iterator() {
        return new ArrayList<RepositoryService>(this.services.values()).iterator();
    }

    private void validate(RepositoryService service) throws IllegalArgumentException {
        try {
            Utils.notNull("browser", service.proxy().browser());
            Utils.notNull("importers", service.proxy().importers());
            Utils.notNull("publishers", service.proxy().publishers());
            if (service.proxy().importers().isEmpty() && service.proxy().publishers().isEmpty()) {
                throw new IllegalStateException("service defines no importers or publishers");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid repository service", e);
        }
    }
}

