/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.virtualrepository.Property;
import org.virtualrepository.Utils;

public class Properties
implements Iterable<Property> {
    private final Map<String, Property> properties = new HashMap<String, Property>();

    @Override
    public Iterator<Property> iterator() {
        return this.properties.values().iterator();
    }

    public synchronized void add(Property ... properties) {
        Utils.notNull("properties", properties);
        for (Property property : properties) {
            this.properties.put(property.name(), property);
        }
    }

    public synchronized boolean contains(String name) {
        Utils.notNull("property name", name);
        return this.properties.containsKey(name);
    }

    public void remove(String name) {
        Utils.notNull("property name", name);
        if (this.properties.remove(name) == null) {
            throw new IllegalStateException("unknown property " + name);
        }
    }

    public synchronized Property lookup(String name) {
        Utils.notNull("property name", name);
        Property property = this.properties.get(name);
        if (property == null) {
            throw new IllegalStateException("unknown property " + name);
        }
        return property;
    }

    public synchronized boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public synchronized int size() {
        return this.properties.size();
    }

    public Property[] toArray() {
        return this.properties.values().toArray(new Property[this.properties.size()]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Properties other = (Properties)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public String toString() {
        int maxLen = 100;
        return this.properties != null ? this.toString(this.properties.values(), 100) : null;
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }
}

