/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sdmxregistry;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.sdmxregistry.GCubeProxy;
import org.virtual.sdmxregistry.GCubeRegistry;
import org.virtual.sdmxregistry.GenericProxy;
import org.virtual.sdmxregistry.GenericRegistry;
import org.virtual.sdmxregistry.Registry;
import org.virtual.sdmxregistry.RegistryConfiguration;
import org.virtual.sdmxregistry.RegistryProxy;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.spi.Lifecycle;
import org.virtualrepository.spi.Plugin;
import org.virtualrepository.spi.ServiceProxy;

public class RegistryPlugin
implements Plugin,
Lifecycle {
    private static final String configurationFile = "sdmxregistries.xml";
    private static final Logger log = LoggerFactory.getLogger(RegistryPlugin.class);
    private final List<RepositoryService> services = new ArrayList<RepositoryService>();

    public void init() throws Exception {
        log.info("configuring plugin");
        RegistryConfiguration config = this.loadConfiguration();
        for (Registry registry : config.registries()) {
            RegistryProxy proxy = null;
            if (registry instanceof GenericRegistry) {
                proxy = new GenericProxy((GenericRegistry)registry);
            } else if (registry instanceof GCubeRegistry) {
                proxy = new GCubeProxy((GCubeRegistry)registry);
            }
            RepositoryService service = new RepositoryService(registry.name(), (ServiceProxy)proxy, registry.properties());
            this.services.add(service);
        }
    }

    public List<RepositoryService> services() {
        return this.services;
    }

    private RegistryConfiguration loadConfiguration() throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RegistryConfiguration.class});
        URL configResource = this.getClass().getClassLoader().getResource(configurationFile);
        if (configResource == null) {
            throw new IllegalStateException("cannot find configuration file sdmxregistries.xml");
        }
        return (RegistryConfiguration)context.createUnmarshaller().unmarshal(configResource);
    }
}

