/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.common.software.model.ProcessorConfig;

public class GlobalConfig {
    public static final String EXPORT_FILENAME_PROPERTY_NAME = "export_filename";
    public static final String PROCESSORS_PROPERTY_NAME = "processors";
    @JsonProperty(value="processors")
    protected Map<String, ProcessorConfig> processorConfigurations;
    protected Map<String, JsonNode> properties = new LinkedHashMap<String, JsonNode>();
    @JsonIgnore
    protected ObjectNode originalJson;

    public Map<String, ProcessorConfig> getProcessorConfigurations() {
        return this.processorConfigurations;
    }

    @JsonIgnore
    public ObjectNode getOriginalJson() {
        return this.originalJson;
    }

    @JsonIgnore
    public void setOriginalJson(ObjectNode originalJson) {
        this.originalJson = originalJson;
    }

    @JsonAnyGetter
    public Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    @JsonAnySetter
    public void addProperty(String key, JsonNode value) {
        this.properties.put(key, value);
    }

    @JsonIgnore
    public JsonNode getProperty(String key) {
        return this.properties.get(key);
    }

    protected String getExportFileName(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            return simpleDateFormat.format(Calendar.getInstance().getTime());
        }
        return fileName;
    }

    public String getFileName() {
        JsonNode jsonNode = this.getProperty(EXPORT_FILENAME_PROPERTY_NAME);
        String fileName = jsonNode.getNodeType() == JsonNodeType.NULL ? null : jsonNode.asText();
        fileName = this.getExportFileName(fileName);
        return fileName;
    }
}

