package org.gcube.common.storagehub.client.dsl;

import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;

public class Util {
 
	protected static ItemContainer<? extends Item> getContainerFromItem(Item item,ItemManagerClient itemClient){
		if (item instanceof AbstractFileItem fileItem) 
			return new FileContainer(itemClient, fileItem);
		else if (item instanceof FolderItem folderItem)
			return new FolderContainer(itemClient, folderItem);
		else return new GenericItemContainer(itemClient, item);
	}

	public static String getVREGroupFromContext(String context) {
		return context.replace("/", "-").substring(1);
	}
	
}
