/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.io;

import java.io.Reader;
import java.util.Map;
import org.gcube.io.jsonwebtoken.impl.io.AbstractParser;
import org.gcube.io.jsonwebtoken.impl.lang.Converter;
import org.gcube.io.jsonwebtoken.impl.lang.Function;
import org.gcube.io.jsonwebtoken.lang.Assert;

public class ConvertingParser<T>
extends AbstractParser<T> {
    private final Function<Reader, Map<String, ?>> deserializer;
    private final Converter<T, Object> converter;

    public ConvertingParser(Function<Reader, Map<String, ?>> deserializer, Converter<T, Object> converter) {
        this.deserializer = (Function)Assert.notNull(deserializer, (String)"Deserializer function cannot be null.");
        this.converter = (Converter)Assert.notNull(converter, (String)"Converter cannot be null.");
    }

    public final T parse(Reader reader) {
        Assert.notNull((Object)reader, (String)"Reader cannot be null.");
        Map<String, ?> m = this.deserializer.apply(reader);
        return this.converter.applyFrom(m);
    }
}

