/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.stubs.jaxws;

import jakarta.xml.ws.Binding;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.soap.AddressingFeature;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import jakarta.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.gcube.common.clients.stubs.jaxws.GCoreEndpointReference;
import org.gcube.common.clients.stubs.jaxws.GCoreService;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.common.clients.stubs.jaxws.StubCache;
import org.gcube.common.clients.stubs.jaxws.StubFactoryDSL;
import org.gcube.common.clients.stubs.jaxws.handlers.GCoreJAXWSHandler;
import org.gcube.common.clients.stubs.jaxws.proxies.GenericProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StubFactory<T>
implements StubFactoryDSL.AtClause<T> {
    private static final Logger log = LoggerFactory.getLogger(StubFactory.class);
    private static String proxyHost;
    private static int proxyPort;
    private static StubCache cache;
    private final GCoreService<T> target;

    public StubFactory(GCoreService<T> target) {
        JAXWSUtils.notNull("gCore Service", target);
        this.target = target;
    }

    @Override
    public T at(EndpointReference reference) {
        JAXWSUtils.notNull("instance reference", reference);
        GCoreEndpointReference epr = new GCoreEndpointReference(reference);
        String proxied = this.setProxyOn(epr.address);
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder().address(proxied);
        reference = epr.key == null ? StubFactory.buildEndpointReference(builder) : StubFactory.buildEndpointReference(builder.referenceParameter(epr.key));
        return this.at(proxied, reference, new AddressingFeature());
    }

    @Override
    public T at(URI address) {
        JAXWSUtils.notNull("endpoint address", address);
        EndpointReference reference = StubFactory.buildEndpointReference(new W3CEndpointReferenceBuilder().address(address.toString()));
        return this.at(reference);
    }

    private T at(String endpointAddress, EndpointReference reference, AddressingFeature ... features) {
        try {
            if (Thread.currentThread().getContextClassLoader() == null) {
                Thread.currentThread().setContextClassLoader(StubFactory.class.getClassLoader());
            }
            Service service = this.buildService(endpointAddress + "?wsdl", this.target.type(), this.target.qName());
            log.info("target type is {} ", this.target.type());
            T stub = this.getPortWithClassLoader(service, reference, this.target.type(), features);
            BindingProvider provider = (BindingProvider)stub;
            this.registerHandler(provider, this.target);
            return GenericProxyFactory.getProxy(this.target.type(), endpointAddress, stub);
        }
        catch (Error e) {
            cache.clear(this.target.type());
            throw new RuntimeException("could not configure discovery service", e);
        }
        catch (Exception e) {
            throw new RuntimeException("could not configure discovery service", e);
        }
    }

    public static <T> StubFactoryDSL.AtClause<T> stubFor(GCoreService<T> service) {
        return new StubFactory<T>(service);
    }

    private synchronized Service buildService(final String wsdlAddress, Class<?> type, final QName name) throws Exception {
        Callable<Service> task = new Callable<Service>(){

            @Override
            public Service call() throws Exception {
                log.info("fetching wsdl for {} at {}", (Object)name.getLocalPart(), (Object)wsdlAddress);
                return StubFactory.this.createServiceWithClassLoader(new URL(wsdlAddress), name);
            }
        };
        Service service = cache.get(type, task);
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Service createServiceWithClassLoader(URL wsdlUrl, QName serviceName) throws Exception {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Service service = Service.create((URL)wsdlUrl, (QName)serviceName);
            return service;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> P getPortWithClassLoader(Service service, EndpointReference reference, Class<P> serviceInterface, AddressingFeature ... features) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Object object = service.getPort(reference, serviceInterface, (WebServiceFeature[])features);
            return (P)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void registerHandler(BindingProvider provider, GCoreService<?> context) {
        Binding binding = provider.getBinding();
        List currentChain = binding.getHandlerChain();
        GCoreJAXWSHandler handler = new GCoreJAXWSHandler(context);
        currentChain.add(handler);
        binding.setHandlerChain(currentChain);
    }

    public static void setProxy(String host, int port) {
        proxyHost = host;
        proxyPort = port;
    }

    private String setProxyOn(String address) {
        if (proxyHost != null) {
            try {
                URI u = URI.create(address);
                return new URI(u.getScheme(), u.getUserInfo(), proxyHost, proxyPort, u.getPath(), u.getQuery(), u.getFragment()).toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return address;
    }

    private static EndpointReference buildEndpointReference(W3CEndpointReferenceBuilder builder) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(StubFactory.class.getClassLoader());
            W3CEndpointReference w3CEndpointReference = builder.build();
            return w3CEndpointReference;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    static {
        cache = new StubCache();
    }
}

