/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security.secrets;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gcube.common.iam.D4ScienceIAMClientAuthz;
import org.gcube.common.iam.OIDCBearerAuth;
import org.gcube.common.security.Owner;
import org.gcube.common.security.secrets.Secret;
import org.gcube.common.security.secrets.UmaTokenSecret;

public class AccessTokenSecret
extends Secret {
    public static final long TOLERANCE = TimeUnit.MILLISECONDS.toMillis(200L);
    private String accessToken;
    private String context;
    private UmaTokenSecret umaTokenSecret;
    protected boolean initialised = false;

    public AccessTokenSecret(String accessToken, String context) {
        this.accessToken = accessToken;
        this.context = context;
        this.init();
    }

    private synchronized void init() {
        try {
            OIDCBearerAuth auth = OIDCBearerAuth.fromAccessTokenString((String)this.accessToken);
            D4ScienceIAMClientAuthz authz = auth.authorize(this.context);
            this.umaTokenSecret = new UmaTokenSecret(authz.getAccessTokenString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void refreshAccessToken() {
        try {
            OIDCBearerAuth auth = OIDCBearerAuth.fromAccessTokenString((String)this.accessToken);
            D4ScienceIAMClientAuthz authz = auth.authorize(this.context);
            this.umaTokenSecret = new UmaTokenSecret(authz.getAccessTokenString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Owner getOwner() {
        return this.umaTokenSecret.getOwner();
    }

    public int priority() {
        return this.umaTokenSecret.priority();
    }

    public String getContext() {
        if (this.umaTokenSecret.isExpired()) {
            this.refreshAccessToken();
        }
        return this.umaTokenSecret.getContext();
    }

    public Map<String, String> getHTTPAuthorizationHeaders() {
        if (this.umaTokenSecret.isExpired()) {
            this.refreshAccessToken();
        }
        return this.umaTokenSecret.getHTTPAuthorizationHeaders();
    }

    public boolean isValid() {
        if (this.isExpired()) {
            this.refreshAccessToken();
        }
        return this.umaTokenSecret.isValid();
    }

    public boolean isExpired() {
        return this.umaTokenSecret.isExpired();
    }
}

