/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.Key;
import org.gcube.io.jsonwebtoken.impl.security.DefaultKeyPairBuilder;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Strings;
import org.gcube.io.jsonwebtoken.security.Curve;
import org.gcube.io.jsonwebtoken.security.KeyPairBuilder;

abstract class AbstractCurve
implements Curve {
    private final String ID;
    private final String JCA_NAME;

    AbstractCurve(String id, String jcaName) {
        this.ID = (String)Assert.notNull((Object)Strings.clean((String)id), (String)"Curve ID cannot be null or empty.");
        this.JCA_NAME = (String)Assert.notNull((Object)Strings.clean((String)jcaName), (String)"Curve jcaName cannot be null or empty.");
    }

    public String getId() {
        return this.ID;
    }

    public String getJcaName() {
        return this.JCA_NAME;
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Curve) {
            Curve curve = (Curve)obj;
            return this.ID.equals(curve.getId());
        }
        return false;
    }

    public String toString() {
        return this.ID;
    }

    public KeyPairBuilder keyPair() {
        return new DefaultKeyPairBuilder(this.JCA_NAME);
    }

    abstract boolean contains(Key var1);
}

